package eu.dnetlib.espas.gui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public interface MessageServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.MessageService
     */
    void getValidMessages( AsyncCallback<java.util.List<java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.MessageService
     */
    void getMessages( AsyncCallback<java.util.List<eu.dnetlib.espas.gui.shared.Message>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.MessageService
     */
    void deleteMessages( java.util.List<java.lang.String> messageIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.MessageService
     */
    void insertMessage( eu.dnetlib.espas.gui.shared.Message message, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.MessageService
     */
    void updateMessage( eu.dnetlib.espas.gui.shared.Message message, AsyncCallback<Void> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static MessageServiceAsync instance;

        public static final MessageServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (MessageServiceAsync) GWT.create( MessageService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instanciated
        }
    }
}
