package eu.dnetlib.espas.gui.server.utils;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

import eu.dnetlib.espas.gui.shared.ContactUsInfo;
import org.apache.log4j.Logger;

import eu.dnetlib.espas.gui.client.Crypto;
import eu.dnetlib.espas.gui.shared.User;
import eu.dnetlib.espas.gui.shared.UserAccessException;
import eu.dnetlib.utils.MailLibrary;

public class EmailUtils {
	
	private static Logger logger = Logger.getLogger(EmailUtils.class);
	
	private MailLibrary mailLibrary;
	private String baseAddress;

    private String adminEmail;

    public void sendContactUsMail(ContactUsInfo contactUsInfo) throws Exception {

        try {

            mailLibrary.sendEmail(new String[]{adminEmail, contactUsInfo.getEmail()}, "[ESPAS] " + contactUsInfo.getSubject(),
                    "User " + contactUsInfo.getName() + " has sent the following message: \n " + contactUsInfo.getMessage());

        } catch (AddressException e) {
            logger.error("Address Exception", e);
            throw new UserAccessException();
        } catch (MessagingException e) {
            logger.error("Messaging Exception", e);
            throw new UserAccessException();
        }
    }

	public void sendActivationEmail(User user) throws UserAccessException {
		
		try {
			String link = baseAddress + "/myAccount.html?email=" + user.getEmail() + "&activationId=" + user.getActivationId() + "#activate";
            mailLibrary.sendEmail(user.getEmail(), "Account Activation", "Please follow this link " + link + " to activate your account.");
			
		} catch (AddressException e) {
			logger.error("Address Exception", e);
			throw new UserAccessException();
		} catch (MessagingException e) {
			logger.error("Messaging Exception", e);
			throw new UserAccessException();
		}
	}
	
        public void sendDownloadUpdateEmail(User user, String messageSubject, String messageBody ) throws UserAccessException{
            try {
                if(messageSubject==null || messageSubject.isEmpty())
                   messageSubject = "Download file request update";
                if(messageBody==null || messageBody.isEmpty())
                   messageBody = "The status of your download file request has changed. Please go to your account page for further details.";
                
                mailLibrary.sendEmail(user.getEmail(), messageSubject, messageBody);
            } catch (MessagingException ex) {
			logger.error("Messaging Exception", ex);
			throw new UserAccessException();
            }
        }
        
	public void sendResetPasswordEmail(User user, String resetToken) throws UserAccessException {		
		try {
			String link = baseAddress + "/myAccount.html?resetToken=" + Crypto.encrypt(resetToken) + "#reset";
			mailLibrary.sendEmail(user.getEmail(), "Reset Password", "Please follow this link " + link + " to reset your password.");
			
		} catch (AddressException e) {
			logger.error("Address Exception", e);
			throw new UserAccessException();
		} catch (MessagingException e) {
			logger.error("Messaging Exception", e);
			throw new UserAccessException();
		}
	}

	public MailLibrary getMailLibrary() {
		return mailLibrary;
	}

	public void setMailLibrary(MailLibrary mailLibrary) {
		this.mailLibrary = mailLibrary;
	}

	public String getBaseAddress() {
		return baseAddress;
	}

	public void setBaseAddress(String baseAddress) {
		this.baseAddress = baseAddress;
	}

    public String getAdminEmail() {
        return adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }
}
