package eu.dnetlib.espas.gui.client;

import com.google.gwt.user.client.Event;

public class TextField extends com.sencha.gxt.widget.core.client.form.TextField implements ValueChangeCancelField {
	
	public TextField() {
		super();
		sinkEvents(Event.ONPASTE | Event.ONKEYUP);
	}
	
	private String oldValue = "";
	private ValueChangeHandler handler = null;
	
	@Override
	public void onBrowserEvent(Event event) {
		
		super.onBrowserEvent(event);

		switch (event.getTypeInt()) {
		case Event.ONPASTE:
		case Event.ONKEYUP:
			if (this.handler != null) {
				ValueChangeEvent valueChangeEvent = new ValueChangeEvent(this, this.getId(), this.oldValue, getText());
				
				this.handler.handle(valueChangeEvent);
				
				this.oldValue = getText();
			}
			break;
		default:
		}
	}
	
	@Override
	public void cancel() {
		this.setText(oldValue);
		focus();
	}

	public void addValueChangeHandler(ValueChangeHandler handler) {
		this.handler = handler;
	}

}
