package eu.dnetlib.espas.gui.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import eu.dnetlib.espas.gui.client.ContactUsService;
import eu.dnetlib.espas.gui.server.utils.EmailUtils;
import eu.dnetlib.espas.gui.shared.ContactUsInfo;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

/**
 * Created by stefania on 5/21/15.
 */
public class ContactUsServiceImpl extends RemoteServiceServlet implements ContactUsService {

    private EmailUtils emailUtils;

    public void init(ServletConfig config) throws ServletException {

        super.init(config);
        ApplicationContext context = WebApplicationContextUtils
                .getWebApplicationContext(getServletContext());

        emailUtils = (EmailUtils) context.getBean("espas.gui.emailUtils");
    }

    @Override
    public void sendContactUsEmail(ContactUsInfo contactUsInfo) throws Exception {
        emailUtils.sendContactUsMail(contactUsInfo);
    }
}
