package eu.dnetlib.espas.gui.server.user;

import java.util.List;

import eu.dnetlib.espas.gui.shared.User;
import eu.dnetlib.espas.gui.shared.UserAccessException;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly = false)
public interface UserDAO {

	public void insertUser(User user) throws UserAccessException;
	
	public User getUserById(String userEmail, String password) throws UserAccessException;
	
	public User getUserById(String userEmail) throws UserAccessException;
	
	public void updateUser(User user) throws UserAccessException;
	
	public User activateUser(User user) throws UserAccessException;
	
	public void updateResetToken(String userEmail, String resetToken) throws UserAccessException;
	
	public void updateUserPassword(String userEmail, String password) throws UserAccessException;
	
	public List<User> getUsers() throws UserAccessException;
	
	public void activateUsers(List<String> emails) throws UserAccessException;
	
	public void deactivateUsers(List<String> emails) throws UserAccessException;
	
	public void deleteUsers(List<String> emails) throws UserAccessException;
	
	public void addRoleToUser(String email, String role) throws UserAccessException;
	
	public void removeRoleFromUser(String email, String role) throws UserAccessException;
	
	public List<User> getPendingDataProviderUsers() throws UserAccessException;
	
	public void denyDataProviderRoleToUser(String email) throws UserAccessException;
	
	public List<String> getDataProviderUsersEmails() throws UserAccessException;

    public List<User> getDataProviderUsers();
}
