"""HTML character entity references."""

# html/xml named entities
entities = {
'AElig': r'\xc6',
'Aacgr': '&#x0386;',
'Aacute': r'\xc1',
'Abreve': '&#x0102;',
'Abreveac': '&#x1EAE;',
'Abrevedb': '&#x1EB6;',
'Abrevegr': '&#x1EB0;',
'Abreveha': '&#x1EB2;',
'Abreveti': '&#x1EB4;',
'Acaron': '&#x01CD;',
'Acirc': r'\xc2',
'Acy': '&#x0410;',
'Adot': '&#x0226;',
'Adotama': '&#x01E0;',
'Adotb': '&#x1EA0;',
'Aeacute': '&#x01FC;',
'Aemacr': '&#x01E2;',
'Afr': '&#x1d504;',
'Agr': '&#x0391;',
'Agrave': r'\xc0',
'Ahooka': '&#x1EA2;',
'Alpha': '&#x0391;',
'Amacr': '&#x0100;',
'And': '&#x2a53;',
'Aogon': '&#x0104;',
'Aopf': '&#x1d538;',
'ApplyFunction': '&#x2061;',
'Aring': r'\xc5',
'Ascr': '&#x1d49c;',
'Assign': '&#x2254;',
'Atilde': r'\xc3',
'Auml': r'\xc4',
'Backslash': '&#x2216;',
'Barv': '&#x2ae7;',
'Barwed': '&#x2306;',
'Bcy': '&#x0411;',
'Bdota': '&#x1E02;',
'Bdotb': '&#x1E04;',
'Because': '&#x2235;',
'Bernoullis': '&#x212c;',
'Beta': '&#x0392;',
'Bfr': '&#x1d505;',
'Bgr': '&#x0392;',
'Bmacrb': '&#x1E06;',
'Bopf': '&#x1d539;',
'Breve': '&#x02d8;',
'Bscr': '&#x212c;',
'Bumpeq': '&#x224e;',
'CHcy': '&#x0427;',
'COPY': r'\xa9',
'Cacute': '&#x0106;',
'Cap': '&#x22d2;',
'CapitalDifferentialD': '&#x2145;',
'Cayleys': '&#x212d;',
'Ccaron': '&#x010c;',
'Ccedil': r'\xc7',
'Ccirc': '&#x0108;',
'Cconint': '&#x2230;',
'Cdot': '&#x010a;',
'Cedilla': r'\xb8',
'CenterDot': r'\xb7',
'Cfr': '&#x212d;',
'Chi': '&#x03a7;',
'CircleDot': '&#x2299;',
'CircleMinus': '&#x2296;',
'CirclePlus': '&#x2295;',
'CircleTimes': '&#x2297;',
'ClockwiseContourIntegral': '&#x2232;',
'CloseCurlyDoubleQuote': '&#x201d;',
'CloseCurlyQuote': '&#x2019;',
'Colon': '&#x2237;',
'Colone': '&#x2a74;',
'Congruent': '&#x2261;',
'Conint': '&#x222f;',
'ContourIntegral': '&#x222e;',
'Copf': '&#x2102;',
'Coproduct': '&#x2210;',
'CounterClockwiseContourIntegral': '&#x2233;',
'Cross': '&#x2a2f;',
'Cscr': '&#x1d49e;',
'Cup': '&#x22d3;',
'CupCap': '&#x224d;',
'DD': '&#x2145;',
'DDotrahd': '&#x2911;',
'DJcy': '&#x0402;',
'DScy': '&#x0405;',
'DZcy': '&#x040F;',
'Dagger': '&#x2021;',
'Darr': '&#x21a1;',
'Dashv': '&#x2ae4;',
'Dcaron': '&#x010e;',
'Dcommab': '&#x1E10;',
'Dcy': '&#x0414;',
'Ddota': '&#x1E0A;',
'Ddotb': '&#x1E0C;',
'Del': '&#x2207;',
'Delta': '&#x0394;',
'Dfr': '&#x1d507;',
'Dgr': '&#x0394;',
'DiacriticalAcute': r'\xb4',
'DiacriticalDot': '&#x02d9;',
'DiacriticalDoubleAcute': '&#x02dd;',
'DiacriticalGrave': r'`',
'DiacriticalTilde': '&#x02dc;',
'Diamond': '&#x22c4;',
'DifferentialD': '&#x2146;',
'Dmacrb': '&#x1E0E;',
'Dopf': '&#x1d53b;',
'Dot': r'\xa8',
'DotDot': '&#x20dc;',
'DotEqual': '&#x2250;',
'DoubleContourIntegral': '&#x222f;',
'DoubleDot': r'\xa8',
'DoubleDownArrow': '&#x21d3;',
'DoubleLeftArrow': '&#x21d0;',
'DoubleLeftRightArrow': '&#x21d4;',
'DoubleLeftTee': '&#x2ae4;',
'DoubleLongLeftArrow': '&#x27f8;',
'DoubleLongLeftRightArrow': '&#x27fa;',
'DoubleLongRightArrow': '&#x27f9;',
'DoubleRightArrow': '&#x21d2;',
'DoubleRightTee': '&#x22a8;',
'DoubleUpArrow': '&#x21d1;',
'DoubleUpDownArrow': '&#x21d5;',
'DoubleVerticalBar': '&#x2225;',
'DownArrow': '&#x2193;',
'DownArrowBar': '&#x2913;',
'DownArrowUpArrow': '&#x21f5;',
'DownBreve': '&#x0311;',
'DownLeftRightVector': '&#x2950;',
'DownLeftTeeVector': '&#x295e;',
'DownLeftVector': '&#x21bd;',
'DownLeftVectorBar': '&#x2956;',
'DownRightTeeVector': '&#x295f;',
'DownRightVector': '&#x21c1;',
'DownRightVectorBar': '&#x2957;',
'DownTee': '&#x22a4;',
'DownTeeArrow': '&#x21a7;',
'Downarrow': '&#x21d3;',
'Dscr': '&#x1d49f;',
'Dstrok': '&#x0110;',
'EEacgr': '&#x0389;',
'EEgr': '&#x0397;',
'ENG': '&#x014a;',
'ETH': r'\xd0',
'Eacgr': '&#x0388;',
'Eacute': r'\xc9',
'Ebreve': '&#x0114;',
'Ecaron': '&#x011a;',
'Ecedil': '&#x0228;',
'Ecedilbr': '&#x1E1C;',
'Ecirc': r'\xca',
'Ecy': '&#x042D;',
'Edot': '&#x0116;',
'Edotb': '&#x1EB8;',
'Efr': '&#x1d508;',
'Egr': '&#x0395;',
'Egrave': r'\xc8',
'Ehooka': '&#x1EBA;',
'Element': '&#x2208;',
'Emacr': '&#x0112;',
'Emacrac': '&#x1E16;',
'Emacrgr': '&#x1E14;',
'EmptySmallSquare': '&#x25fb;',
'EmptyVerySmallSquare': '&#x25ab;',
'Eogon': '&#x0118;',
'Eopf': '&#x1d53c;',
'Epsilon': '&#x0395;',
'Equal': '&#x2a75;',
'EqualTilde': '&#x2242;',
'Equilibrium': '&#x21cc;',
'Escr': '&#x2130;',
'Esim': '&#x2a73;',
'Eta': '&#x0397;',
'Etilde': '&#x1EBC;',
'Euml': r'\xcb',
'Exists': '&#x2203;',
'ExponentialE': '&#x2147;',
'Fcy': '&#x0424;',
'Fdot': '&#x1E1E;',
'Ffr': '&#x1d509;',
'FilledSmallSquare': '&#x25fc;',
'FilledVerySmallSquare': '&#x25aa;',
'Fopf': '&#x1d53d;',
'ForAll': '&#x2200;',
'Fouriertrf': '&#x2131;',
'Fscr': '&#x2131;',
'GJcy': '&#x0403;',
'GT': r'>',
'Gacute': '&#x01F4;',
'Gamma': '&#x0393;',
'Gammad': '&#x03dc;',
'Gbreve': '&#x011e;',
'Gcaron': '&#x01E6;',
'Gcedil': '&#x0122;',
'Gcirc': '&#x011c;',
'Gcy': '&#x0413;',
'Gdot': '&#x0120;',
'Gfr': '&#x1d50a;',
'Gg': '&#x22d9;',
'Ggr': '&#x0393;',
'Gmacr': '&#x1E20;',
'Gopf': '&#x1d53e;',
'GreaterEqual': '&#x2265;',
'GreaterEqualLess': '&#x22db;',
'GreaterFullEqual': '&#x2267;',
'GreaterGreater': '&#x2aa2;',
'GreaterLess': '&#x2277;',
'GreaterSlantEqual': '&#x2a7e;',
'GreaterTilde': '&#x2273;',
'Gscr': '&#x1d4a2;',
'Gstrok': '&#x01E4;',
'Gt': '&#x226b;',
'HARDcy': '&#x042A;',
'Hacek': '&#x02c7;',
'Hat': r'^',
'Hbreveb': '&#x1E2A;',
'Hcaron': '&#x021E;',
'Hcedil': '&#x1E28;',
'Hcirc': '&#x0124;',
'Hdot': '&#x1E22;',
'Hdotb': '&#x1E24;',
'Hfr': '&#x210c;',
'HilbertSpace': '&#x210b;',
'Hopf': '&#x210d;',
'HorizontalLine': '&#x2500;',
'Hscr': '&#x210b;',
'Hstrok': '&#x0126;',
'Hstroke': '&#x0126;',
'Huml': '&#x1E26;',
'HumpDownHump': '&#x224e;',
'HumpEqual': '&#x224f;',
'IEcy': '&#x0415;',
'IJlig': '&#x0132;',
'IOcy': '&#x0401;',
'Iacgr': '&#x038A;',
'Iacute': r'\xcd',
'Ibreve': '&#x012C;',
'Icaron': '&#x01CF;',
'Icirc': r'\xce',
'Icy': '&#x0418;',
'Idigr': '&#x03AA;',
'Idot': '&#x0130;',
'Idotb': '&#x1ECA;',
'Ifr': '&#x2111;',
'Igr': '&#x0399;',
'Igrave': r'\xcc',
'Ihooka': '&#x1EC8;',
'Im': '&#x2111;',
'Imacr': '&#x012a;',
'ImaginaryI': '&#x2148;',
'Implies': '&#x21d2;',
'Int': '&#x222c;',
'Integral': '&#x222b;',
'Intersection': '&#x22c2;',
'InvisibleComma': '&#x2063;',
'InvisibleTimes': '&#x2062;',
'Iogon': '&#x012e;',
'Iopf': '&#x1d540;',
'Iota': '&#x0399;',
'Iscr': '&#x2110;',
'Itilde': '&#x0128;',
'Iukcy': '&#x0406;',
'Iuml': r'\xcf',
'Jcirc': '&#x0134;',
'Jcy': '&#x0419;',
'Jfr': '&#x1d50d;',
'Jopf': '&#x1d541;',
'Jscr': '&#x1d4a5;',
'Jsercy': '&#x0408;',
'Jukcy': '&#x0404;',
'KHcy': '&#x0425;',
'KHgr': '&#x03A7;',
'KJcy': '&#x040C;',
'Kacute': '&#x1E30;',
'Kappa': '&#x039a;',
'Kcedil': '&#x0136;',
'Kcirc': '&#x01E8;',
'Kcy': '&#x041A;',
'Kdotb': '&#x1E32;',
'Kfr': '&#x1d50e;',
'Kgr': '&#x039A;',
'Kmacrb': '&#x1E34;',
'Kopf': '&#x1d542;',
'Kscr': '&#x1d4a6;',
'LJcy': '&#x0409;',
'LT': r'<',
'Lacute': '&#x0139;',
'Lambda': '&#x039B;',
'Lang': '&#x27ea;',
'Laplacetrf': '&#x2112;',
'Larr': '&#x219e;',
'Lcaron': '&#x013d;',
'Lcedil': '&#x013b;',
'Lcirc': '&#x1E3C;',
'Lcy': '&#x041B;',
'Ldotb': '&#x1E36;',
'Ldotbma': '&#x1E38;',
'LeftAngleBracket': '&#x27e8;',
'LeftArrow': '&#x2190;',
'LeftArrowBar': '&#x21e4;',
'LeftArrowRightArrow': '&#x21c6;',
'LeftCeiling': '&#x2308;',
'LeftDoubleBracket': '&#x27e6;',
'LeftDownTeeVector': '&#x2961;',
'LeftDownVector': '&#x21c3;',
'LeftDownVectorBar': '&#x2959;',
'LeftFloor': '&#x230a;',
'LeftRightArrow': '&#x2194;',
'LeftRightVector': '&#x294e;',
'LeftTee': '&#x22a3;',
'LeftTeeArrow': '&#x21a4;',
'LeftTeeVector': '&#x295a;',
'LeftTriangle': '&#x22b2;',
'LeftTriangleBar': '&#x29cf;',
'LeftTriangleEqual': '&#x22b4;',
'LeftUpDownVector': '&#x2951;',
'LeftUpTeeVector': '&#x2960;',
'LeftUpVector': '&#x21bf;',
'LeftUpVectorBar': '&#x2958;',
'LeftVector': '&#x21bc;',
'LeftVectorBar': '&#x2952;',
'Leftarrow': '&#x21d0;',
'Leftrightarrow': '&#x21d4;',
'LessEqualGreater': '&#x22da;',
'LessFullEqual': '&#x2266;',
'LessGreater': '&#x2276;',
'LessLess': '&#x2aa1;',
'LessSlantEqual': '&#x2a7d;',
'LessTilde': '&#x2272;',
'Lfr': '&#x1d50f;',
'Lgr': '&#x039b;',
'Ll': '&#x22d8;',
'Lleftarrow': '&#x21da;',
'Lmacrb': '&#x1E3A;',
'Lmidot': '&#x013f;',
'LongLeftArrow': '&#x27f5;',
'LongLeftRightArrow': '&#x27f7;',
'LongRightArrow': '&#x27f6;',
'Longleftarrow': '&#x27f8;',
'Longleftrightarrow': '&#x27fa;',
'Longrightarrow': '&#x27f9;',
'Lopf': '&#x1d543;',
'LowerLeftArrow': '&#x2199;',
'LowerRightArrow': '&#x2198;',
'Lscr': '&#x2112;',
'Lsh': '&#x21b0;',
'Lstrok': '&#x0141;',
'Lt': '&#x226a;',
'Macute': '&#x1E3E;',
'Map': '&#x2905;',
'Mcy': '&#x041C;',
'Mdot': '&#x1E40;',
'Mdotb': '&#x1E42;',
'MediumSpace': '&#x205f;',
'Mellintrf': '&#x2133;',
'Mfr': '&#x1d510;',
'Mgr': '&#x039C;',
'MinusPlus': '&#x2213;',
'Mopf': '&#x1d544;',
'Mscr': '&#x2133;',
'Mu': '&#x039c;',
'NJcy': '&#x040A;',
'Nacute': '&#x0143;',
'Ncaron': '&#x0147;',
'Ncedil': '&#x0145;',
'Ncy': '&#x041D;',
'Ndot': '&#x1E44;',
'Ndotb': '&#x1E46;',
'NegativeMediumSpace': '&#x200b;',
'NegativeThickSpace': '&#x200b;',
'NegativeThinSpace': '&#x200b;',
'NegativeVeryThinSpace': '&#x200b;',
'NestedGreaterGreater': '&#x226b;',
'NestedLessLess': '&#x226a;',
'NewLine': r'\\n',
'Nfr': '&#x1d511;',
'Ngr': '&#x039D;',
'Ngrave': '&#x01F8;',
'Nmacrb': '&#x1E48;',
'NoBreak': '&#x2060;',
'NonBreakingSpace': r'\xa0',
'Nopf': '&#x2115;',
'Not': '&#x2aec;',
'NotCongruent': '&#x2262;',
'NotCupCap': '&#x226d;',
'NotDoubleVerticalBar': '&#x2226;',
'NotElement': '&#x2209;',
'NotEqual': '&#x2260;',
'NotEqualTilde': '&#x2242;&#x0338;',
'NotExists': '&#x2204;',
'NotGreater': '&#x226f;',
'NotGreaterEqual': '&#x2271;',
'NotGreaterFullEqual': '&#x2267;&#x0338;',
'NotGreaterGreater': '&#x226b;&#x0338;',
'NotGreaterLess': '&#x2279;',
'NotGreaterSlantEqual': '&#x2a7e;&#x0338;',
'NotGreaterTilde': '&#x2275;',
'NotHumpDownHump': '&#x224e;&#x0338;',
'NotHumpEqual': '&#x224f;&#x0338;',
'NotLeftTriangle': '&#x22ea;',
'NotLeftTriangleBar': '&#x29cf;&#x0338;',
'NotLeftTriangleEqual': '&#x22ec;',
'NotLess': '&#x226e;',
'NotLessEqual': '&#x2270;',
'NotLessGreater': '&#x2278;',
'NotLessLess': '&#x226a;&#x0338;',
'NotLessSlantEqual': '&#x2a7d;&#x0338;',
'NotLessTilde': '&#x2274;',
'NotNestedGreaterGreater': '&#x2aa2;&#x0338;',
'NotNestedLessLess': '&#x2aa1;&#x0338;',
'NotPrecedes': '&#x2280;',
'NotPrecedesEqual': '&#x2aaf;&#x0338;',
'NotPrecedesSlantEqual': '&#x22e0;',
'NotReverseElement': '&#x220c;',
'NotRightTriangle': '&#x22eb;',
'NotRightTriangleBar': '&#x29d0;&#x0338;',
'NotRightTriangleEqual': '&#x22ed;',
'NotSquareSubset': '&#x228f;&#x0338;',
'NotSquareSubsetEqual': '&#x22e2;',
'NotSquareSuperset': '&#x2290;&#x0338;',
'NotSquareSupersetEqual': '&#x22e3;',
'NotSubset': '&#x2282;&#x20d2;',
'NotSubsetEqual': '&#x2288;',
'NotSucceeds': '&#x2281;',
'NotSucceedsEqual': '&#x2ab0;&#x0338;',
'NotSucceedsSlantEqual': '&#x22e1;',
'NotSucceedsTilde': '&#x227f;&#x0338;',
'NotSuperset': '&#x2283;&#x20d2;',
'NotSupersetEqual': '&#x2289;',
'NotTilde': '&#x2241;',
'NotTildeEqual': '&#x2244;',
'NotTildeFullEqual': '&#x2247;',
'NotTildeTilde': '&#x2249;',
'NotVerticalBar': '&#x2224;',
'Nscr': '&#x1d4a9;',
'Ntilde': r'\xd1',
'Nu': '&#x039d;',
'OElig': '&#x0152;',
'OHacgr': '&#x038F;',
'OHgr': '&#x03a9;',
'Oacgr': '&#x038C;',
'Oacute': r'\xd3',
'Obreve': '&#x014E;',
'Ocaron': '&#x01D1;',
'Ocirc': r'\xd4',
'Ocy': '&#x041E;',
'Odblac': '&#x0150;',
'Odota': '&#x022E;',
'Odotama': '&#x0230;',
'Odotb': '&#x1ECC;',
'Ofr': '&#x1d512;',
'Ogr': '&#x039F;',
'Ograve': r'\xd2',
'Ohooka': '&#x1ECE;',
'Ohorn': '&#x01A0;',
'Ohornac': '&#x1EE8;',
'Ohorndb': '&#x1EE2;',
'Ohorngr': '&#x1EDC;',
'Ohornha': '&#x1EDE;',
'Ohornti': '&#x1EE0;',
'Omacr': '&#x014c;',
'Omacrac': '&#x1E52;',
'Omacrgr': '&#x1E50;',
'Omega': '&#x03A9;',
'Omicron': '&#x039f;',
'Oogon': '&#x01EA;',
'Oogonma': '&#x01EC;',
'Oopf': '&#x1d546;',
'OpenCurlyDoubleQuote': '&#x201c;',
'OpenCurlyQuote': '&#x2018;',
'Or': '&#x2a54;',
'Oscr': '&#x1d4aa;',
'Oslash': r'\xd8',
'Otilde': r'\xd5',
'Otimes': '&#x2a37;',
'Ouml': r'\xd6',
'OverBar': '&#x203e;',
'OverBrace': '&#x23de;',
'OverBracket': '&#x23b4;',
'OverParenthesis': '&#x23dc;',
'PHgr': '&#x03a6;',
'PSgr': '&#x03a8;',
'Pacute': '&#x1E54;',
'PartialD': '&#x2202;',
'Pcy': '&#x041F;',
'Pdota': '&#x1E56;',
'Pfr': '&#x1d513;',
'Pgr': '&#x03a0;',
'Phi': '&#x03A6;',
'Pi': '&#x03A0;',
'PlusMinus': r'\xb1',
'Poincareplane': '&#x210c;',
'Popf': '&#x2119;',
'Pr': '&#x2abb;',
'Precedes': '&#x227a;',
'PrecedesEqual': '&#x2aaf;',
'PrecedesSlantEqual': '&#x227c;',
'PrecedesTilde': '&#x227e;',
'Prime': '&#x2033;',
'Product': '&#x220f;',
'Proportion': '&#x2237;',
'Proportional': '&#x221d;',
'Pscr': '&#x1d4ab;',
'Psi': '&#x03A8;',
'Qfr': '&#x1d514;',
'Qopf': '&#x211a;',
'Qscr': '&#x1d4ac;',
'RBarr': '&#x2910;',
'REG': r'\xae',
'Racute': '&#x0154;',
'Rang': '&#x27eb;',
'Rarr': '&#x21a0;',
'Rarrtl': '&#x2916;',
'Rcaron': '&#x0158;',
'Rcedil': '&#x0156;',
'Rcy': '&#x0420;',
'Rdota': '&#x1E58;',
'Rdotb': '&#x1E5A;',
'Re': '&#x211c;',
'ReverseElement': '&#x220b;',
'ReverseEquilibrium': '&#x21cb;',
'ReverseUpEquilibrium': '&#x296f;',
'Rfr': '&#x211c;',
'Rgr': '&#x03A1;',
'Rho': '&#x03a1;',
'RightAngleBracket': '&#x27e9;',
'RightArrow': '&#x2192;',
'RightArrowBar': '&#x21e5;',
'RightArrowLeftArrow': '&#x21c4;',
'RightCeiling': '&#x2309;',
'RightDoubleBracket': '&#x27e7;',
'RightDownTeeVector': '&#x295d;',
'RightDownVector': '&#x21c2;',
'RightDownVectorBar': '&#x2955;',
'RightFloor': '&#x230b;',
'RightTee': '&#x22a2;',
'RightTeeArrow': '&#x21a6;',
'RightTeeVector': '&#x295b;',
'RightTriangle': '&#x22b3;',
'RightTriangleBar': '&#x29d0;',
'RightTriangleEqual': '&#x22b5;',
'RightUpDownVector': '&#x294f;',
'RightUpTeeVector': '&#x295c;',
'RightUpVector': '&#x21be;',
'RightUpVectorBar': '&#x2954;',
'RightVector': '&#x21c0;',
'RightVectorBar': '&#x2953;',
'Rightarrow': '&#x21d2;',
'Rmacrb': '&#x1E5E;',
'Ropf': '&#x211d;',
'RoundImplies': '&#x2970;',
'Rrightarrow': '&#x21db;',
'Rscr': '&#x211b;',
'Rsh': '&#x21b1;',
'RuleDelayed': '&#x29f4;',
'SHCHcy': '&#x0429;',
'SHcy': '&#x0428;',
'SOFTcy': '&#x042C;',
'Sacute': '&#x015A;',
'Sacuteda': '&#x1E64;',
'Sc': '&#x2abc;',
'Scaron': '&#x0160;',
'Scaronda': '&#x1E66;',
'Scedil': '&#x015E;',
'Scirc': '&#x015C;',
'Scy': '&#x0421;',
'Sdota': '&#x1E60;',
'Sdotb': '&#x1E62;',
'Sdotbda': '&#x1E68;',
'Sfr': '&#x1d516;',
'Sgr': '&#x03a3;',
'ShortDownArrow': '&#x2193;',
'ShortLeftArrow': '&#x2190;',
'ShortRightArrow': '&#x2192;',
'ShortUpArrow': '&#x2191;',
'Sigma': '&#x03A3;',
'SmallCircle': '&#x2218;',
'Sopf': '&#x1d54a;',
'Sqrt': '&#x221a;',
'Square': '&#x25a1;',
'SquareIntersection': '&#x2293;',
'SquareSubset': '&#x228f;',
'SquareSubsetEqual': '&#x2291;',
'SquareSuperset': '&#x2290;',
'SquareSupersetEqual': '&#x2292;',
'SquareUnion': '&#x2294;',
'Sscr': '&#x1d4ae;',
'Star': '&#x22c6;',
'Sub': '&#x22d0;',
'Subset': '&#x22d0;',
'SubsetEqual': '&#x2286;',
'Succeeds': '&#x227b;',
'SucceedsEqual': '&#x2ab0;',
'SucceedsSlantEqual': '&#x227d;',
'SucceedsTilde': '&#x227f;',
'SuchThat': '&#x220b;',
'Sum': '&#x2211;',
'Sup': '&#x22d1;',
'Superset': '&#x2283;',
'SupersetEqual': '&#x2287;',
'Supset': '&#x22d1;',
'THORN': r'\xde',
'THgr': '&#x0398;',
'TRADE': '&#x2122;',
'TSHcy': '&#x040B;',
'TScy': '&#x0426;',
'Tab': r'\t',
'Tau': '&#x03a4;',
'Tcaron': '&#x0164;',
'Tcedil': '&#x0162;',
'Tcommab': '&#x021A;',
'Tcy': '&#x0422;',
'Tdot': '&#x1E6A;',
'Tdotb': '&#x1E6C;',
'Tfr': '&#x1d517;',
'Tgr': '&#x03A4;',
'Therefore': '&#x2234;',
'Theta': '&#x0398;',
'ThickSpace': '&#x205f;&#x200a;',
'ThinSpace': '&#x2009;',
'Tilde': '&#x223c;',
'TildeEqual': '&#x2243;',
'TildeFullEqual': '&#x2245;',
'TildeTilde': '&#x2248;',
'Tmacrb': '&#x1E6E;',
'Topf': '&#x1d54b;',
'TripleDot': '&#x20db;',
'Tscr': '&#x1d4af;',
'Tstrok': '&#x0166;',
'Uacgr': '&#x038E;',
'Uacute': r'\xda',
'Uarr': '&#x219f;',
'Uarrocir': '&#x2949;',
'Ubrcy': '&#x040E;',
'Ubreve': '&#x016C;',
'Ucirc': r'\xdb',
'Ucy': '&#x0423;',
'Udblac': '&#x0170;',
'Udigr': '&#x03AB;',
'Udlbdb': '&#x1E72;',
'Udotb': '&#x1EE4;',
'Ufr': '&#x1d518;',
'Ugr': '&#x03a5;',
'Ugrave': r'\xd9',
'Uhorn': '&#x01AF;',
'Uhorndb': '&#x1EF0;',
'Uhorngr': '&#x1EEA;',
'Uhornha': '&#x1EEC;',
'Uhornti': '&#x1EEE;',
'Umacr': '&#x016A;',
'Umacrum': '&#x1E7A;',
'UnderBar': r'_',
'UnderBrace': '&#x23df;',
'UnderBracket': '&#x23b5;',
'UnderParenthesis': '&#x23dd;',
'Union': '&#x22c3;',
'UnionPlus': '&#x228e;',
'Uogon': '&#x0172;',
'Uopf': '&#x1d54c;',
'UpArrow': '&#x2191;',
'UpArrowBar': '&#x2912;',
'UpArrowDownArrow': '&#x21c5;',
'UpDownArrow': '&#x2195;',
'UpEquilibrium': '&#x296e;',
'UpTee': '&#x22a5;',
'UpTeeArrow': '&#x21a5;',
'Uparrow': '&#x21d1;',
'Updownarrow': '&#x21d5;',
'UpperLeftArrow': '&#x2196;',
'UpperRightArrow': '&#x2197;',
'Upsi': '&#x03A5;',
'Upsilon': '&#x03a5;',
'Uring': '&#x016E;',
'Uscr': '&#x1d4b0;',
'Utilde': '&#x0168;',
'Uuml': r'\xdc',
'VDash': '&#x22ab;',
'Vbar': '&#x2aeb;',
'Vcy': '&#x0412;',
'Vdash': '&#x22a9;',
'Vdashl': '&#x2ae6;',
'Vdotb': '&#x1E7E;',
'Vee': '&#x22c1;',
'Verbar': '&#x2016;',
'Vert': '&#x2016;',
'VerticalBar': '&#x2223;',
'VerticalLine': r'|',
'VerticalSeparator': '&#x2758;',
'VerticalTilde': '&#x2240;',
'VeryThinSpace': '&#x200a;',
'Vfr': '&#x1d519;',
'Vopf': '&#x1d54d;',
'Vscr': '&#x1d4b1;',
'Vtilde': '&#x1E7C;',
'Vvdash': '&#x22aa;',
'Wacute': '&#x1E82;',
'Wcirc': '&#x0174;',
'Wdot': '&#x1E86;',
'Wedge': '&#x22c0;',
'Wfr': '&#x1d51a;',
'Wgrave': '&#x1E80;',
'Wopf': '&#x1d54e;',
'Wscr': '&#x1d4b2;',
'Wuml': '&#x1E84;',
'Xdot': '&#x1E8A;',
'Xfr': '&#x1d51b;',
'Xgr': '&#x039e;',
'Xi': '&#x039E;',
'Xopf': '&#x1d54f;',
'Xscr': '&#x1d4b3;',
'Xuml': '&#x1E8C;',
'YAcy': '&#x042F;',
'YIcy': '&#x0407;',
'YUcy': '&#x042E;',
'Yacute': r'\xdd',
'Ycirc': '&#x0176;',
'Ycy': '&#x042B;',
'Ydot': '&#x1E8E;',
'Ydotb': '&#x1EF4;',
'Yfr': '&#x1d51c;',
'Ygrave': '&#x1EF2;',
'Yhooka': '&#x1EF6;',
'Ymacr': '&#x0232;',
'Yopf': '&#x1d550;',
'Yscr': '&#x1d4b4;',
'Ytilde': '&#x1EF8;',
'Yuml': '&#x0178;',
'ZHcy': '&#x0416;',
'Zacute': '&#x0179;',
'Zcaron': '&#x017D;',
'Zcirc': '&#x1E90;',
'Zcy': '&#x0417;',
'Zdot': '&#x017B;',
'Zdotb': '&#x1E92;',
'ZeroWidthSpace': '&#x200b;',
'Zeta': '&#x0396;',
'Zfr': '&#x2128;',
'Zgr': '&#x0396;',
'Zlowline': '&#x1E94;',
'Zopf': '&#x2124;',
'Zscr': '&#x1d4b5;',
'aacgr': '&#x03AC;',
'aacute': r'\xe1',
'abreve': '&#x0103;',
'abreveac': '&#x1EAF;',
'abrevedb': '&#x1EB7;',
'abrevegr': '&#x1EB1;',
'abreveha': '&#x1EB3;',
'abreveti': '&#x1EB5;',
'ac': '&#x223e;',
'acE': '&#x223e;&#x0333;',
'acaron': '&#x01CE;',
'acd': '&#x223f;',
'acirc': r'\xe2',
'acute': r'\xb4',
'acy': '&#x0430;',
'adot': '&#x0227;',
'adotama': '&#x01E1;',
'adotb': '&#x1EA1;',
'aeacute': '&#x01FD;',
'aelig': r'\xe6',
'aemacr': '&#x01E3;',
'af': '&#x2061;',
'afr': '&#x1d51e;',
'agr': '&#x03b1;',
'agrave': r'\xe0',
'ahooka': '&#x1EA3;',
'alefsym': '&#x2135;',
'aleph': '&#x2135;',
'alpha': '&#x03B1;',
'amacr': '&#x0101;',
'amalg': '&#x2a3f;',
'and': '&#x2227;',
'andand': '&#x2a55;',
'andd': '&#x2a5c;',
'andslope': '&#x2a58;',
'andv': '&#x2a5a;',
'ang': '&#x2220;',
'ange': '&#x29a4;',
'angle': '&#x2220;',
'angmsd': '&#x2221;',
'angmsdaa': '&#x29a8;',
'angmsdab': '&#x29a9;',
'angmsdac': '&#x29aa;',
'angmsdad': '&#x29ab;',
'angmsdae': '&#x29ac;',
'angmsdaf': '&#x29ad;',
'angmsdag': '&#x29ae;',
'angmsdah': '&#x29af;',
'angrt': '&#x221f;',
'angrtvb': '&#x22be;',
'angrtvbd': '&#x299d;',
'angsph': '&#x2222;',
'angst': r'\xc5',
'angzarr': '&#x237c;',
'aogon': '&#x0105;',
'aopf': '&#x1d552;',
'ap': '&#x2248;',
'apE': '&#x2a70;',
'apacir': '&#x2a6f;',
'ape': '&#x224a;',
'apid': '&#x224b;',
'apos': '&#x02BC;',
'approx': '&#x2248;',
'approxeq': '&#x224a;',
'aring': r'\xe5',
'ascr': '&#x1d4b6;',
'ast': r'*',
'asymp': '&#x2248;',
'asympeq': '&#x224d;',
'atilde': r'\xe3',
'auml': r'\xe4',
'awconint': '&#x2233;',
'awint': '&#x2a11;',
'bNot': '&#x2aed;',
'backcong': '&#x224c;',
'backepsilon': '&#x03f6;',
'backprime': '&#x2035;',
'backsim': '&#x223d;',
'backsimeq': '&#x22cd;',
'barvee': '&#x22bd;',
'barwed': '&#x2305;',
'barwedge': '&#x2305;',
'bbrk': '&#x23b5;',
'bbrktbrk': '&#x23b6;',
'bcong': '&#x224c;',
'bcy': '&#x0431;',
'bdota': '&#x1E03;',
'bdotb': '&#x1E05;',
'bdquo': '&#x201e;',
'becaus': '&#x2235;',
'because': '&#x2235;',
'bemptyv': '&#x29b0;',
'bepsi': '&#x03f6;',
'bernou': '&#x212c;',
'beta': '&#x03B2;',
'beth': '&#x2136;',
'between': '&#x226c;',
'bfr': '&#x1d51f;',
'bgr': '&#x03b2;',
'bigcap': '&#x22c2;',
'bigcirc': '&#x25ef;',
'bigcup': '&#x22c3;',
'bigodot': '&#x2a00;',
'bigoplus': '&#x2a01;',
'bigotimes': '&#x2a02;',
'bigsqcup': '&#x2a06;',
'bigstar': '&#x2605;',
'bigtriangledown': '&#x25bd;',
'bigtriangleup': '&#x25b3;',
'biguplus': '&#x2a04;',
'bigvee': '&#x22c1;',
'bigwedge': '&#x22c0;',
'bkarow': '&#x290d;',
'blacklozenge': '&#x29eb;',
'blacksquare': '&#x25aa;',
'blacktriangle': '&#x25b4;',
'blacktriangledown': '&#x25be;',
'blacktriangleleft': '&#x25c2;',
'blacktriangleright': '&#x25b8;',
'blank': '&#x2423;',
'blk12': '&#x2592;',
'blk14': '&#x2591;',
'blk34': '&#x2593;',
'block': '&#x2588;',
'bmacrb': '&#x1E07;',
'bne': '&#x20e5;',
'bnequiv': '&#x2261;&#x20e5;',
'bnot': '&#x2310;',
'bopf': '&#x1d553;',
'bot': '&#x22a5;',
'bottom': '&#x22a5;',
'bowtie': '&#x22c8;',
'boxDL': '&#x2557;',
'boxDR': '&#x2554;',
'boxDl': '&#x2556;',
'boxDr': '&#x2553;',
'boxH': '&#x2550;',
'boxHD': '&#x2566;',
'boxHU': '&#x2569;',
'boxHd': '&#x2564;',
'boxHu': '&#x2567;',
'boxUL': '&#x255d;',
'boxUR': '&#x255a;',
'boxUl': '&#x255c;',
'boxUr': '&#x2559;',
'boxV': '&#x2551;',
'boxVH': '&#x256c;',
'boxVL': '&#x2563;',
'boxVR': '&#x2560;',
'boxVh': '&#x256b;',
'boxVl': '&#x2562;',
'boxVr': '&#x255f;',
'boxbox': '&#x29c9;',
'boxdL': '&#x2555;',
'boxdR': '&#x2552;',
'boxdl': '&#x2510;',
'boxdr': '&#x250c;',
'boxh': '&#x2500;',
'boxhD': '&#x2565;',
'boxhU': '&#x2568;',
'boxhd': '&#x252c;',
'boxhu': '&#x2534;',
'boxminus': '&#x229f;',
'boxplus': '&#x229e;',
'boxtimes': '&#x22a0;',
'boxuL': '&#x255b;',
'boxuR': '&#x2558;',
'boxul': '&#x2518;',
'boxur': '&#x2514;',
'boxv': '&#x2502;',
'boxvH': '&#x256a;',
'boxvL': '&#x2561;',
'boxvR': '&#x255e;',
'boxvh': '&#x253c;',
'boxvl': '&#x2524;',
'boxvr': '&#x251c;',
'bprime': '&#x2035;',
'breve': '&#x02D8;',
'breveb': '&#x032E;',
'brvbar': r'\xa6',
'bscr': '&#x1d4b7;',
'bsemi': '&#x204f;',
'bsim': '&#x223d;',
'bsime': '&#x22cd;',
'bsol': r'\\',
'bsolb': '&#x29c5;',
'bsolhsub': '&#x27c8;',
'bull': '&#x2022;',
'bullet': '&#x2022;',
'bump': '&#x224e;',
'bumpE': '&#x2aae;',
'bumpe': '&#x224f;',
'bumpeq': '&#x224f;',
'cacute': '&#x0107;',
'candra': '&#x0310;',
'cap': '&#x2229;',
'capand': '&#x2a44;',
'capbrcup': '&#x2a49;',
'capcap': '&#x2a4b;',
'capcup': '&#x2a47;',
'capdot': '&#x2a40;',
'caps': '&#x2229;&#xfe00;',
'caret': '&#x2041;',
'caron': '&#x02C7;',
'ccaps': '&#x2a4d;',
'ccaron': '&#x010d;',
'ccedil': r'\xe7',
'ccirc': '&#x0109;',
'ccups': '&#x2a4c;',
'ccupssm': '&#x2a50;',
'cdot': '&#x010b;',
'cedil': r'\xb8',
'cemptyv': '&#x29b2;',
'cent': r'\xa2',
'centerdot': r'\xb7',
'cfr': '&#x1d520;',
'chcy': '&#x0447;',
'check': '&#x2713;',
'checkmark': '&#x2713;',
'chi': '&#x03C7;',
'cir': '&#x25cb;',
'cirE': '&#x29c3;',
'circ': '&#x02c6;',
'circeq': '&#x2257;',
'circlearrowleft': '&#x21ba;',
'circlearrowright': '&#x21bb;',
'circledR': r'\xae',
'circledS': '&#x24c8;',
'circledast': '&#x229b;',
'circledcirc': '&#x229a;',
'circleddash': '&#x229d;',
'cire': '&#x2257;',
'cirfnint': '&#x2a10;',
'cirmid': '&#x2aef;',
'cirscir': '&#x29c2;',
'clubs': '&#x2663;',
'clubsuit': '&#x2663;',
'colon': r':',
'colone': '&#x2254;',
'coloneq': '&#x2254;',
'comma': r',',
'commaa': '&#x0313;',
'commab': '&#x0326;',
'commat': r'@',
'comp': '&#x2201;',
'compfn': '&#x2218;',
'complement': '&#x2201;',
'complexes': '&#x2102;',
'cong': '&#x2245;',
'congdot': '&#x2a6d;',
'conint': '&#x222e;',
'copf': '&#x1d554;',
'coprod': '&#x2210;',
'copy': r'\xa9',
'copysr': '&#x2117;',
'crarr': '&#x21b5;',
'cross': '&#x2717;',
'cscr': '&#x1d4b8;',
'csub': '&#x2acf;',
'csube': '&#x2ad1;',
'csup': '&#x2ad0;',
'csupe': '&#x2ad2;',
'ctdot': '&#x22ef;',
'cudarrl': '&#x2938;',
'cudarrr': '&#x2935;',
'cuepr': '&#x22de;',
'cuesc': '&#x22df;',
'cularr': '&#x21b6;',
'cularrp': '&#x293d;',
'cup': '&#x222a;',
'cupbrcap': '&#x2a48;',
'cupcap': '&#x2a46;',
'cupcup': '&#x2a4a;',
'cupdot': '&#x228d;',
'cupor': '&#x2a45;',
'cups': '&#x222a;&#xfe00;',
'curarr': '&#x21b7;',
'curarrm': '&#x293c;',
'curlyeqprec': '&#x22de;',
'curlyeqsucc': '&#x22df;',
'curlyvee': '&#x22ce;',
'curlywedge': '&#x22cf;',
'curren': r'\xa4',
'curvearrowleft': '&#x21b6;',
'curvearrowright': '&#x21b7;',
'cuvee': '&#x22ce;',
'cuwed': '&#x22cf;',
'cwconint': '&#x2232;',
'cwint': '&#x2231;',
'cylcty': '&#x232d;',
'dArr': '&#x21d3;',
'dHar': '&#x2965;',
'dagger': '&#x2020;',
'daleth': '&#x2138;',
'darr': '&#x2193;',
'dash': '&#x2010;',
'dashv': '&#x22a3;',
'dbkarow': '&#x290f;',
'dblac': '&#x02DD;',
'dbldotb': '&#x0324;',
'dblunder': '&#x0333;',
'dcaron': '&#x010f;',
'dcommab': '&#x1E11;',
'dcy': '&#x0434;',
'dd': '&#x2146;',
'ddagger': '&#x2021;',
'ddarr': '&#x21ca;',
'ddota': '&#x1E0B;',
'ddotb': '&#x1E0D;',
'ddotseq': '&#x2a77;',
'deg': r'\xb0',
'delta': '&#x03B4;',
'demptyv': '&#x29b1;',
'dfisht': '&#x297f;',
'dfr': '&#x1d521;',
'dgr': '&#x03b4;',
'dharl': '&#x21c3;',
'dharr': '&#x21c2;',
'diam': '&#x22c4;',
'diamond': '&#x22c4;',
'diamondsuit': '&#x2666;',
'diams': '&#x2666;',
'die': r'\xa8',
'digamma': '&#x03dd;',
'disin': '&#x22f2;',
'div': r'\xf7',
'divide': r'\xf7',
'divideontimes': '&#x22c7;',
'divonx': '&#x22c7;',
'djcy': '&#x0452;',
'dlcorn': '&#x231e;',
'dlcrop': '&#x230d;',
'dmacrb': '&#x1E0F;',
'dollar': r'$',
'dopf': '&#x1d555;',
'dot': '&#x02D9;',
'dotb': '&#x0323;',
'doteq': '&#x2250;',
'doteqdot': '&#x2251;',
'dotminus': '&#x2238;',
'dotplus': '&#x2214;',
'dotsquare': '&#x22a1;',
'doublebarwedge': '&#x2306;',
'downarrow': '&#x2193;',
'downdownarrows': '&#x21ca;',
'downharpoonleft': '&#x21c3;',
'downharpoonright': '&#x21c2;',
'drbkarow': '&#x2910;',
'drcorn': '&#x231f;',
'drcrop': '&#x230c;',
'dscr': '&#x1d4b9;',
'dscy': '&#x0455;',
'dsol': '&#x29f6;',
'dstrok': '&#x0111;',
'dtdot': '&#x22f1;',
'dtri': '&#x25bf;',
'dtrif': '&#x25be;',
'duarr': '&#x21f5;',
'duhar': '&#x296f;',
'dwangle': '&#x29a6;',
'dzcy': '&#x045f;',
'dzigrarr': '&#x27ff;',
'eDDot': '&#x2a77;',
'eDot': '&#x2251;',
'eacgr': '&#x03AD;',
'eacute': r'\xe9',
'easter': '&#x2a6e;',
'ebreve': '&#x0115;',
'ecaron': '&#x011b;',
'ecedil': '&#x0229;',
'ecedilbr': '&#x1E1D;',
'ecir': '&#x2256;',
'ecirc': r'\xea',
'ecolon': '&#x2255;',
'ecy': '&#x044d;',
'edot': '&#x0117;',
'edotb': '&#x1EB9;',
'ee': '&#x2147;',
'eeacgr': '&#x03AE;',
'eegr': '&#x03b7;',
'efDot': '&#x2252;',
'efr': '&#x1d522;',
'eg': '&#x2a9a;',
'egr': '&#x03b5;',
'egrave': r'\xe8',
'egs': '&#x2a96;',
'egsdot': '&#x2a98;',
'ehooka': '&#x1EBB;',
'el': '&#x2a99;',
'elinters': '&#x23e7;',
'ell': '&#x2113;',
'els': '&#x2a95;',
'elsdot': '&#x2a97;',
'emacr': '&#x0113;',
'emacrac': '&#x1E17;',
'emacrgr': '&#x1E15;',
'empty': '&#x2205;',
'emptyset': '&#x2205;',
'emptyv': '&#x2205;',
'emsp': '&#x2003;',
'emsp13': '&#x2004;',
'emsp14': '&#x2005;',
'eng': '&#x014b;',
'ensp': '&#x2002;',
'eogon': '&#x0119;',
'eopf': '&#x1d556;',
'epar': '&#x22d5;',
'eparsl': '&#x29e3;',
'eplus': '&#x2a71;',
'epsi': '&#x03B5;',
'epsilon': '&#x03b5;',
'epsiv': '&#x03f5;',
'eqcirc': '&#x2256;',
'eqcolon': '&#x2255;',
'eqsim': '&#x2242;',
'eqslantgtr': '&#x2a96;',
'eqslantless': '&#x2a95;',
'equals': r'=',
'equest': '&#x225f;',
'equiv': '&#x2261;',
'equivDD': '&#x2a78;',
'eqvparsl': '&#x29e5;',
'erDot': '&#x2253;',
'erarr': '&#x2971;',
'escr': '&#x212f;',
'esdot': '&#x2250;',
'esim': '&#x2242;',
'eta': '&#x03B7;',
'eth': r'\xf0',
'etilde': '&#x1EBD;',
'euml': r'\xeb',
'euro': '&#x20ac;',
'excl': r'!',
'exist': '&#x2203;',
'expectation': '&#x2130;',
'exponentiale': '&#x2147;',
'fallingdotseq': '&#x2252;',
'fcy': '&#x0444;',
'fdot': '&#x1E1F;',
'female': '&#x2640;',
'ffilig': '&#xfb03;',
'fflig': '&#xfb00;',
'ffllig': '&#xfb04;',
'ffr': '&#x1d523;',
'filig': '&#xfb01;',
'fjlig': r'fj',
'flat': '&#x266d;',
'fllig': '&#xfb02;',
'fltns': '&#x25b1;',
'fnof': '&#x0192;',
'fopf': '&#x1d557;',
'forall': '&#x2200;',
'fork': '&#x22d4;',
'forkv': '&#x2ad9;',
'fpartint': '&#x2a0d;',
'frac12': r'\xbd',
'frac13': '&#x2153;',
'frac14': r'\xbc',
'frac15': '&#x2155;',
'frac16': '&#x2159;',
'frac18': '&#x215b;',
'frac23': '&#x2154;',
'frac25': '&#x2156;',
'frac34': r'\xbe',
'frac35': '&#x2157;',
'frac38': '&#x215c;',
'frac45': '&#x2158;',
'frac56': '&#x215a;',
'frac58': '&#x215d;',
'frac78': '&#x215e;',
'frasl': '&#x2044;',
'frown': '&#x2322;',
'fscr': '&#x1d4bb;',
'gE': '&#x2267;',
'gEl': '&#x2a8c;',
'gacute': '&#x01f5;',
'gamma': '&#x03B3;',
'gammad': '&#x03DD;',
'gap': '&#x2a86;',
'gbreve': '&#x011f;',
'gcaron': '&#x01E7;',
'gcedil': '&#x0123;',
'gcirc': '&#x011d;',
'gcy': '&#x0433;',
'gdot': '&#x0121;',
'ge': '&#x2265;',
'gel': '&#x22db;',
'geq': '&#x2265;',
'geqq': '&#x2267;',
'geqslant': '&#x2a7e;',
'ges': '&#x2a7e;',
'gescc': '&#x2aa9;',
'gesdot': '&#x2a80;',
'gesdoto': '&#x2a82;',
'gesdotol': '&#x2a84;',
'gesl': '&#x22db;&#xfe00;',
'gesles': '&#x2a94;',
'gfr': '&#x1d524;',
'gg': '&#x226b;',
'ggg': '&#x22d9;',
'ggr': '&#x03b3;',
'gimel': '&#x2137;',
'gjcy': '&#x0453;',
'gl': '&#x2277;',
'glE': '&#x2a92;',
'gla': '&#x2aa5;',
'glj': '&#x2aa4;',
'gmacr': '&#x1E21;',
'gnE': '&#x2269;',
'gnap': '&#x2a8a;',
'gnapprox': '&#x2a8a;',
'gne': '&#x2a88;',
'gneq': '&#x2a88;',
'gneqq': '&#x2269;',
'gnsim': '&#x22e7;',
'gopf': '&#x1d558;',
'grave': r'`',
'gscr': '&#x210a;',
'gsim': '&#x2273;',
'gsime': '&#x2a8e;',
'gsiml': '&#x2a90;',
'gstrok': '&#x01E5;',
'gt': r'>',
'gtcc': '&#x2aa7;',
'gtcir': '&#x2a7a;',
'gtdot': '&#x22d7;',
'gtlPar': '&#x2995;',
'gtquest': '&#x2a7c;',
'gtrapprox': '&#x2a86;',
'gtrarr': '&#x2978;',
'gtrdot': '&#x22d7;',
'gtreqless': '&#x22db;',
'gtreqqless': '&#x2a8c;',
'gtrless': '&#x2277;',
'gtrsim': '&#x2273;',
'gvertneqq': '&#x2269;&#xfe00;',
'gvnE': '&#x2269;&#xfe00;',
'hArr': '&#x21d4;',
'hairsp': '&#x200a;',
'half': r'\xbd',
'hamilt': '&#x210b;',
'hardcy': '&#x044a;',
'hardsign': '&#x02BA;',
'harr': '&#x2194;',
'harrcir': '&#x2948;',
'harrw': '&#x21ad;',
'hbar': '&#x210f;',
'hbreveb': '&#x1E2B;',
'hcaron': '&#x021F;',
'hcedil': '&#x1E29;',
'hcirc': '&#x0125;',
'hdot': '&#x1E23;',
'hdotb': '&#x1E25;',
'hearts': '&#x2665;',
'heartsuit': '&#x2665;',
'hellip': '&#x2026;',
'hercon': '&#x22b9;',
'hfr': '&#x1d525;',
'hksearow': '&#x2925;',
'hkswarow': '&#x2926;',
'hlowline': '&#x1E96;',
'hoarr': '&#x21ff;',
'homtht': '&#x223b;',
'hooka': '&#x0309;',
'hookleftarrow': '&#x21a9;',
'hookrightarrow': '&#x21aa;',
'hopf': '&#x1d559;',
'horbar': '&#x2015;',
'hscr': '&#x1d4bd;',
'hslash': '&#x210f;',
'hstrok': '&#x0127;',
'hstroke': '&#x0127;',
'huml': '&#x1E27;',
'hybull': '&#x2043;',
'hyphen': '&#x2010;',
'iacgr': '&#x03AF;',
'iacute': r'\xed',
'ibreve': '&#x012D;',
'ic': '&#x2063;',
'icaron': '&#x01D0;',
'icirc': r'\xee',
'icy': '&#x0438;',
'idiagr': '&#x0390;',
'idigr': '&#x03CA;',
'idotb': '&#x1ECB;',
'iecy': '&#x0435;',
'iexcl': r'\xa1',
'iff': '&#x21d4;',
'ifr': '&#x1d526;',
'igr': '&#x03b9;',
'igrave': r'\xec',
'ihooka': '&#x1EC9;',
'ii': '&#x2148;',
'iiiint': '&#x2a0c;',
'iiint': '&#x222d;',
'iinfin': '&#x29dc;',
'iiota': '&#x2129;',
'ijlig': '&#x0133;',
'imacr': '&#x012b;',
'image': '&#x2111;',
'imagline': '&#x2110;',
'imagpart': '&#x2111;',
'imath': '&#x0131;',
'imof': '&#x22b7;',
'imped': '&#x01b5;',
'in': '&#x2208;',
'incare': '&#x2105;',
'infin': '&#x221e;',
'infintie': '&#x29dd;',
'inodot': '&#x0131;',
'int': '&#x222b;',
'intcal': '&#x22ba;',
'integers': '&#x2124;',
'intercal': '&#x22ba;',
'intlarhk': '&#x2a17;',
'intprod': '&#x2a3c;',
'iocy': '&#x0451;',
'iogon': '&#x012f;',
'iopf': '&#x1d55a;',
'iota': '&#x03B9;',
'iprod': '&#x2a3c;',
'iquest': r'\xbf',
'iscr': '&#x1d4be;',
'isin': '&#x2208;',
'isinE': '&#x22f9;',
'isindot': '&#x22f5;',
'isins': '&#x22f4;',
'isinsv': '&#x22f3;',
'isinv': '&#x2208;',
'it': '&#x2062;',
'itilde': '&#x0129;',
'iukcy': '&#x0456;',
'iuml': r'\xef',
'jcaron': '&#x01F0;',
'jcirc': '&#x0135;',
'jcy': '&#x0439;',
'jfr': '&#x1d527;',
'jmath': '&#x0237;',
'jopf': '&#x1d55b;',
'jscr': '&#x1d4bf;',
'jsercy': '&#x0458;',
'jukcy': '&#x0454;',
'kacute': '&#x1E31;',
'kappa': '&#x03BA;',
'kappav': '&#x03F0;',
'kcedil': '&#x0137;',
'kcirc': '&#x01E9;',
'kcy': '&#x043A;',
'kdotb': '&#x1E33;',
'kfr': '&#x1d528;',
'kgr': '&#x3ba;',
'kgreen': '&#x0138;',
'khcy': '&#x0445;',
'khgr': '&#x03c7;',
'kjcy': '&#x045c;',
'kmacrb': '&#x1E35;',
'kopf': '&#x1d55c;',
'kscr': '&#x1d4c0;',
'lAarr': '&#x21da;',
'lArr': '&#x21d0;',
'lAtail': '&#x291b;',
'lBarr': '&#x290e;',
'lE': '&#x2266;',
'lEg': '&#x2a8b;',
'lHar': '&#x2962;',
'lacute': '&#x013a;',
'laemptyv': '&#x29b4;',
'lagran': '&#x2112;',
'lambda': '&#x03BB;',
'lang': '&#x27e8;',
'langd': '&#x2991;',
'langle': '&#x27e8;',
'lap': '&#x2a85;',
'laquo': r'\xab',
'larr': '&#x2190;',
'larrb': '&#x21e4;',
'larrbfs': '&#x291f;',
'larrfs': '&#x291d;',
'larrhk': '&#x21a9;',
'larrlp': '&#x21ab;',
'larrpl': '&#x2939;',
'larrsim': '&#x2973;',
'larrtl': '&#x21a2;',
'lat': '&#x2aab;',
'latail': '&#x2919;',
'late': '&#x2aad;',
'lates': '&#x2aad;&#xfe00;',
'lbarr': '&#x290c;',
'lbbrk': '&#x2772;',
'lbrace': r'{',
'lbrack': r'[',
'lbrke': '&#x298b;',
'lbrksld': '&#x298f;',
'lbrkslu': '&#x298d;',
'lcaron': '&#x013e;',
'lcedil': '&#x013c;',
'lceil': '&#x2308;',
'lcirc': '&#x1E3D;',
'lcub': r'{',
'lcy': '&#x043B;',
'ldbltil': '&#xFE22;',
'ldca': '&#x2936;',
'ldotb': '&#x1E37;',
'ldotbma': '&#x1E39;',
'ldquo': '&#x201c;',
'ldquor': '&#x201e;',
'ldrdhar': '&#x2967;',
'ldrushar': '&#x294b;',
'ldsh': '&#x21b2;',
'le': '&#x2264;',
'leftarrow': '&#x2190;',
'leftarrowtail': '&#x21a2;',
'leftharpoondown': '&#x21bd;',
'leftharpoonup': '&#x21bc;',
'leftleftarrows': '&#x21c7;',
'leftrightarrow': '&#x2194;',
'leftrightarrows': '&#x21c6;',
'leftrightharpoons': '&#x21cb;',
'leftrightsquigarrow': '&#x21ad;',
'leftthreetimes': '&#x22cb;',
'leg': '&#x22da;',
'leq': '&#x2264;',
'leqq': '&#x2266;',
'leqslant': '&#x2a7d;',
'les': '&#x2a7d;',
'lescc': '&#x2aa8;',
'lesdot': '&#x2a7f;',
'lesdoto': '&#x2a81;',
'lesdotor': '&#x2a83;',
'lesg': '&#x22da;&#xfe00;',
'lesges': '&#x2a93;',
'lessapprox': '&#x2a85;',
'lessdot': '&#x22d6;',
'lesseqgtr': '&#x22da;',
'lesseqqgtr': '&#x2a8b;',
'lessgtr': '&#x2276;',
'lesssim': '&#x2272;',
'lfisht': '&#x297c;',
'lfloor': '&#x230a;',
'lfr': '&#x1d529;',
'lg': '&#x2276;',
'lgE': '&#x2a91;',
'lgr': '&#x03bb;',
'lhard': '&#x21bd;',
'lharu': '&#x21bc;',
'lharul': '&#x296a;',
'lhblk': '&#x2584;',
'ljcy': '&#x0459;',
'll': '&#x226a;',
'llarr': '&#x21c7;',
'llcorner': '&#x231e;',
'llhard': '&#x296b;',
'llig': '&#xFE20;',
'lltri': '&#x25fa;',
'lmacrb': '&#x1E3B;',
'lmidot': '&#x0140;',
'lmoust': '&#x23b0;',
'lmoustache': '&#x23b0;',
'lnE': '&#x2268;',
'lnap': '&#x2a89;',
'lnapprox': '&#x2a89;',
'lne': '&#x2a87;',
'lneq': '&#x2a87;',
'lneqq': '&#x2268;',
'lnsim': '&#x22e6;',
'loang': '&#x27ec;',
'loarr': '&#x21fd;',
'lobrk': '&#x27e6;',
'longleftarrow': '&#x27f5;',
'longleftrightarrow': '&#x27f7;',
'longmapsto': '&#x27fc;',
'longrightarrow': '&#x27f6;',
'looparrowleft': '&#x21ab;',
'looparrowright': '&#x21ac;',
'lopar': '&#x2985;',
'lopf': '&#x1d55d;',
'loplus': '&#x2a2d;',
'lotimes': '&#x2a34;',
'lowast': '&#x2217;',
'lowbar': r'_',
'loz': '&#x25ca;',
'lozenge': '&#x25ca;',
'lozf': '&#x29eb;',
'lpar': r'(',
'lparlt': '&#x2993;',
'lrarr': '&#x21c6;',
'lrcorner': '&#x231f;',
'lrhar': '&#x21cb;',
'lrhard': '&#x296d;',
'lrm': '&#x200e;',
'lrtri': '&#x22bf;',
'lsaquo': '&#x2039;',
'lscr': '&#x1d4c1;',
'lsh': '&#x21b0;',
'lsim': '&#x2272;',
'lsime': '&#x2a8d;',
'lsimg': '&#x2a8f;',
'lsqb': r'[',
'lsquo': '&#x2018;',
'lsquor': '&#x201a;',
'lstrok': '&#x0142;',
'lt': r'<',
'ltcc': '&#x2aa6;',
'ltcir': '&#x2a79;',
'ltdot': '&#x22d6;',
'lthree': '&#x22cb;',
'ltimes': '&#x22c9;',
'ltlarr': '&#x2976;',
'ltquest': '&#x2a7b;',
'ltrPar': '&#x2996;',
'ltri': '&#x25c3;',
'ltrie': '&#x22b4;',
'ltrif': '&#x25c2;',
'lurdshar': '&#x294a;',
'luruhar': '&#x2966;',
'lvertneqq': '&#x2268;&#xfe00;',
'lvnE': '&#x2268;&#xfe00;',
'mDDot': '&#x223a;',
'macr': r'\xaf',
'macute': '&#x1E3F;',
'male': '&#x2642;',
'malt': '&#x2720;',
'maltese': '&#x2720;',
'map': '&#x21a6;',
'mapsto': '&#x21a6;',
'mapstodown': '&#x21a7;',
'mapstoleft': '&#x21a4;',
'mapstoup': '&#x21a5;',
'marker': '&#x25ae;',
'mcomma': '&#x2a29;',
'mcy': '&#x043C;',
'mdash': '&#x2014;',
'mdot': '&#x1E41;',
'mdotb': '&#x1E43;',
'measuredangle': '&#x2221;',
'mfr': '&#x1d52a;',
'mgr': '&#x03bc;',
'mho': '&#x2127;',
'micro': r'\xb5',
'mid': '&#x2223;',
'midast': r'*',
'midcir': '&#x2af0;',
'middot': r'\xb7',
'minus': '&#x2212;',
'minusb': '&#x229f;',
'minusd': '&#x2238;',
'minusdu': '&#x2a2a;',
'mlcp': '&#x2adb;',
'mldr': '&#x2026;',
'mllhring': '&#x02BF;',
'mlrhring': '&#x02BE;',
'mnplus': '&#x2213;',
'models': '&#x22a7;',
'mopf': '&#x1d55e;',
'mp': '&#x2213;',
'mscr': '&#x1d4c2;',
'mstpos': '&#x223e;',
'mu': '&#x03BC;',
'multimap': '&#x22b8;',
'mumap': '&#x22b8;',
'nGg': '&#x22d9;&#x0338;',
'nGt': '&#x226b;&#x20d2;',
'nGtv': '&#x226b;&#x0338;',
'nLeftarrow': '&#x21cd;',
'nLeftrightarrow': '&#x21ce;',
'nLl': '&#x22d8;&#x0338;',
'nLt': '&#x226a;&#x20d2;',
'nLtv': '&#x226a;&#x0338;',
'nRightarrow': '&#x21cf;',
'nVDash': '&#x22af;',
'nVdash': '&#x22ae;',
'nabla': '&#x2207;',
'nacute': '&#x0144;',
'nang': '&#x2220;&#x20d2;',
'nap': '&#x2249;',
'napE': '&#x2a70;&#x0338;',
'napid': '&#x224b;&#x0338;',
'napos': '&#x0149;',
'napprox': '&#x2249;',
'natur': '&#x266e;',
'natural': '&#x266e;',
'naturals': '&#x2115;',
'nbsp': r'\xa0',
'nbump': '&#x224e;&#x0338;',
'nbumpe': '&#x224f;&#x0338;',
'ncap': '&#x2a43;',
'ncaron': '&#x0148;',
'ncedil': '&#x0146;',
'ncong': '&#x2247;',
'ncongdot': '&#x2a6d;&#x0338;',
'ncup': '&#x2a42;',
'ncy': '&#x043D;',
'ndash': '&#x2013;',
'ndot': '&#x1E45;',
'ndotb': '&#x1E47;',
'ne': '&#x2260;',
'neArr': '&#x21d7;',
'nearhk': '&#x2924;',
'nearr': '&#x2197;',
'nearrow': '&#x2197;',
'nedot': '&#x2250;&#x0338;',
'nequiv': '&#x2262;',
'nesear': '&#x2928;',
'nesim': '&#x2242;&#x0338;',
'nexist': '&#x2204;',
'nexists': '&#x2204;',
'nfr': '&#x1d52b;',
'ngE': '&#x2267;&#x0338;',
'nge': '&#x2271;',
'ngeq': '&#x2271;',
'ngeqq': '&#x2267;&#x0338;',
'ngeqslant': '&#x2a7e;&#x0338;',
'nges': '&#x2a7e;&#x0338;',
'ngr': '&#x03bd;',
'ngrave': '&#x01F9;',
'ngsim': '&#x2275;',
'ngt': '&#x226f;',
'ngtr': '&#x226f;',
'nhArr': '&#x21ce;',
'nharr': '&#x21ae;',
'nhpar': '&#x2af2;',
'ni': '&#x220b;',
'nis': '&#x22fc;',
'nisd': '&#x22fa;',
'niv': '&#x220b;',
'njcy': '&#x045a;',
'nlArr': '&#x21cd;',
'nlE': '&#x2266;&#x0338;',
'nlarr': '&#x219a;',
'nldr': '&#x2025;',
'nle': '&#x2270;',
'nleftarrow': '&#x219a;',
'nleftrightarrow': '&#x21ae;',
'nleq': '&#x2270;',
'nleqq': '&#x2266;&#x0338;',
'nleqslant': '&#x2a7d;&#x0338;',
'nles': '&#x2a7d;&#x0338;',
'nless': '&#x226e;',
'nlsim': '&#x2274;',
'nlt': '&#x226e;',
'nltri': '&#x22ea;',
'nltrie': '&#x22ec;',
'nmacrb': '&#x1E49;',
'nmid': '&#x2224;',
'nopf': '&#x1d55f;',
'not': r'\xac',
'notin': '&#x2209;',
'notinE': '&#x22f9;&#x0338;',
'notindot': '&#x22f5;&#x0338;',
'notinva': '&#x2209;',
'notinvb': '&#x22f7;',
'notinvc': '&#x22f6;',
'notni': '&#x220c;',
'notniva': '&#x220c;',
'notnivb': '&#x22fe;',
'notnivc': '&#x22fd;',
'npar': '&#x2226;',
'nparallel': '&#x2226;',
'nparsl': '&#x2afd;&#x20e5;',
'npart': '&#x2202;&#x0338;',
'npolint': '&#x2a14;',
'npr': '&#x2280;',
'nprcue': '&#x22e0;',
'npre': '&#x2aaf;&#x0338;',
'nprec': '&#x2280;',
'npreceq': '&#x2aaf;&#x0338;',
'nrArr': '&#x21cf;',
'nrarr': '&#x219b;',
'nrarrc': '&#x2933;&#x0338;',
'nrarrw': '&#x219d;&#x0338;',
'nrightarrow': '&#x219b;',
'nrtri': '&#x22eb;',
'nrtrie': '&#x22ed;',
'nsc': '&#x2281;',
'nsccue': '&#x22e1;',
'nsce': '&#x2ab0;&#x0338;',
'nscr': '&#x1d4c3;',
'nshortmid': '&#x2224;',
'nshortparallel': '&#x2226;',
'nsim': '&#x2241;',
'nsime': '&#x2244;',
'nsimeq': '&#x2244;',
'nsmid': '&#x2224;',
'nspar': '&#x2226;',
'nsqsube': '&#x22e2;',
'nsqsupe': '&#x22e3;',
'nsub': '&#x2284;',
'nsubE': '&#x2ac5;&#x0338;',
'nsube': '&#x2288;',
'nsubset': '&#x2282;&#x20d2;',
'nsubseteq': '&#x2288;',
'nsubseteqq': '&#x2ac5;&#x0338;',
'nsucc': '&#x2281;',
'nsucceq': '&#x2ab0;&#x0338;',
'nsup': '&#x2285;',
'nsupE': '&#x2ac6;&#x0338;',
'nsupe': '&#x2289;',
'nsupset': '&#x2283;&#x20d2;',
'nsupseteq': '&#x2289;',
'nsupseteqq': '&#x2ac6;&#x0338;',
'ntgl': '&#x2279;',
'ntilde': r'\xf1',
'ntlg': '&#x2278;',
'ntriangleleft': '&#x22ea;',
'ntrianglelefteq': '&#x22ec;',
'ntriangleright': '&#x22eb;',
'ntrianglerighteq': '&#x22ed;',
'nu': '&#x03BD;',
'num': r'#',
'numero': '&#x2116;',
'numsp': '&#x2007;',
'nvDash': '&#x22ad;',
'nvHarr': '&#x2904;',
'nvap': '&#x224d;&#x20d2;',
'nvdash': '&#x22ac;',
'nvge': '&#x2265;&#x20d2;',
'nvgt': r'>&#x20d2;',
'nvinfin': '&#x29de;',
'nvlArr': '&#x2902;',
'nvle': '&#x2264;&#x20d2;',
'nvlt': r'<&#x20d2;',
'nvltrie': '&#x22b4;&#x20d2;',
'nvrArr': '&#x2903;',
'nvrtrie': '&#x22b5;&#x20d2;',
'nvsim': '&#x223c;&#x20d2;',
'nwArr': '&#x21d6;',
'nwarhk': '&#x2923;',
'nwarr': '&#x2196;',
'nwarrow': '&#x2196;',
'nwnear': '&#x2927;',
'oS': '&#x24c8;',
'oacgr': '&#x03CC;',
'oacute': r'\xf3',
'oast': '&#x229b;',
'obreve': '&#x014F;',
'ocaron': '&#x01D2;',
'ocir': '&#x229a;',
'ocirc': r'\xf4',
'ocy': '&#x043E;',
'odash': '&#x229d;',
'odblac': '&#x0151;',
'odiv': '&#x2a38;',
'odot': '&#x2299;',
'odota': '&#x022F;',
'odotama': '&#x0231;',
'odotb': '&#x1ECD;',
'odsold': '&#x29bc;',
'oelig': '&#x0153;',
'ofcir': '&#x29bf;',
'ofr': '&#x1d52c;',
'ogon': '&#x02DB;',
'ogr': '&#x03BF;',
'ograve': r'\xf2',
'ogt': '&#x29c1;',
'ohacgr': '&#x03CE;',
'ohbar': '&#x29b5;',
'ohgr': '&#x03c9;',
'ohm': '&#x03a9;',
'ohooka': '&#x1ECF;',
'ohorn': '&#x01A1;',
'ohornac': '&#x1EDB;',
'ohorndb': '&#x1EE3;',
'ohorngr': '&#x1EDD;',
'ohornha': '&#x1EDF;',
'ohornti': '&#x1EE1;',
'oint': '&#x222e;',
'olarr': '&#x21ba;',
'olcir': '&#x29be;',
'olcross': '&#x29bb;',
'oline': '&#x203e;',
'olt': '&#x29c0;',
'omacr': '&#x014d;',
'omacrac': '&#x1E53;',
'omacrgr': '&#x1E51;',
'omega': '&#x03C9;',
'omicron': '&#x03bf;',
'omid': '&#x29b6;',
'ominus': '&#x2296;',
'oogon': '&#x01EB;',
'oogonma': '&#x01ED;',
'oopf': '&#x1d560;',
'opar': '&#x29b7;',
'operp': '&#x29b9;',
'oplus': '&#x2295;',
'or': '&#x2228;',
'orarr': '&#x21bb;',
'ord': '&#x2a5d;',
'order': '&#x2134;',
'orderof': '&#x2134;',
'ordf': r'\xaa',
'ordm': r'\xba',
'origof': '&#x22b6;',
'oror': '&#x2a56;',
'orslope': '&#x2a57;',
'orv': '&#x2a5b;',
'oscr': '&#x2134;',
'oslash': r'\xf8',
'osol': '&#x2298;',
'otilde': r'\xf5',
'otimes': '&#x2297;',
'otimesas': '&#x2a36;',
'ouml': r'\xf6',
'ovbar': '&#x233d;',
'pacute': '&#x1E55;',
'par': '&#x2225;',
'para': r'\xb6',
'parallel': '&#x2225;',
'parsim': '&#x2af3;',
'parsl': '&#x2afd;',
'part': '&#x2202;',
'pcy': '&#x043F;',
'pdota': '&#x1E57;',
'percnt': '&#37;',
'period': r'.',
'permil': '&#x2030;',
'perp': '&#x22a5;',
'pertenk': '&#x2031;',
'pfr': '&#x1d52d;',
'pgr': '&#x03c0;',
'phgr': '&#x03c6;',
'phi': '&#x03C6;',
'phiv': '&#x03D5;',
'phmmat': '&#x2133;',
'phone': '&#x260e;',
'pi': '&#x03C0;',
'pitchfork': '&#x22d4;',
'piv': '&#x03D6;',
'planck': '&#x210f;',
'planckh': '&#x210e;',
'plankv': '&#x210f;',
'plus': r'+',
'plusacir': '&#x2a23;',
'plusb': '&#x229e;',
'pluscir': '&#x2a22;',
'plusdo': '&#x2214;',
'plusdu': '&#x2a25;',
'pluse': '&#x2a72;',
'plusmn': r'\xb1',
'plussim': '&#x2a26;',
'plustwo': '&#x2a27;',
'pm': r'\xb1',
'pointint': '&#x2a15;',
'popf': '&#x1d561;',
'pound': r'\xa3',
'pr': '&#x227a;',
'prE': '&#x2ab3;',
'prap': '&#x2ab7;',
'prcue': '&#x227c;',
'pre': '&#x2aaf;',
'prec': '&#x227a;',
'precapprox': '&#x2ab7;',
'preccurlyeq': '&#x227c;',
'preceq': '&#x2aaf;',
'precnapprox': '&#x2ab9;',
'precneqq': '&#x2ab5;',
'precnsim': '&#x22e8;',
'precsim': '&#x227e;',
'prime': '&#x2032;',
'primes': '&#x2119;',
'prnE': '&#x2ab5;',
'prnap': '&#x2ab9;',
'prnsim': '&#x22e8;',
'prod': '&#x220f;',
'profalar': '&#x232e;',
'profline': '&#x2312;',
'profsurf': '&#x2313;',
'prop': '&#x221d;',
'propto': '&#x221d;',
'prsim': '&#x227e;',
'prurel': '&#x22b0;',
'pscr': '&#x1d4c5;',
'psgr': '&#x03c8;',
'psi': '&#x03C8;',
'puncsp': '&#x2008;',
'qfr': '&#x1d52e;',
'qint': '&#x2a0c;',
'qopf': '&#x1d562;',
'qprime': '&#x2057;',
'qscr': '&#x1d4c6;',
'quaternions': '&#x210d;',
'quatint': '&#x2a16;',
'quest': r'?',
'questeq': '&#x225f;',
'rAarr': '&#x21db;',
'rArr': '&#x21d2;',
'rAtail': '&#x291c;',
'rBarr': '&#x290f;',
'rHar': '&#x2964;',
'race': '&#x223d;&#x0331;',
'racute': '&#x0155;',
'radic': '&#x221a;',
'raemptyv': '&#x29b3;',
'rang': '&#x27e9;',
'rangd': '&#x2992;',
'range': '&#x29a5;',
'rangle': '&#x27e9;',
'raquo': r'\xbb',
'rarr': '&#x2192;',
'rarrap': '&#x2975;',
'rarrb': '&#x21e5;',
'rarrbfs': '&#x2920;',
'rarrc': '&#x2933;',
'rarrfs': '&#x291e;',
'rarrhk': '&#x21aa;',
'rarrlp': '&#x21ac;',
'rarrpl': '&#x2945;',
'rarrsim': '&#x2974;',
'rarrtl': '&#x21a3;',
'rarrw': '&#x219d;',
'ratail': '&#x291a;',
'ratio': '&#x2236;',
'rationals': '&#x211a;',
'rbarr': '&#x290d;',
'rbbrk': '&#x2773;',
'rbrace': r'}',
'rbrack': r']',
'rbrke': '&#x298c;',
'rbrksld': '&#x298e;',
'rbrkslu': '&#x2990;',
'rcaron': '&#x0159;',
'rcedil': '&#x0157;',
'rceil': '&#x2309;',
'rcommaa': '&#x0315;',
'rcub': r'}',
'rcy': '&#x0440;',
'rdbltil': '&#xFE23;',
'rdca': '&#x2937;',
'rdldhar': '&#x2969;',
'rdota': '&#x1E59;',
'rdotb': '&#x1E5B;',
'rdquo': '&#x201d;',
'rdquor': '&#x201d;',
'rdsh': '&#x21b3;',
'real': '&#x211c;',
'realine': '&#x211b;',
'realpart': '&#x211c;',
'reals': '&#x211d;',
'rect': '&#x25ad;',
'reg': r'\xae',
'rfisht': '&#x297d;',
'rfloor': '&#x230b;',
'rfr': '&#x1d52f;',
'rgr': '&#x03c1;',
'rhard': '&#x21c1;',
'rharu': '&#x21c0;',
'rharul': '&#x296c;',
'rho': '&#x03C1;',
'rhov': '&#x03F1;',
'rightarrow': '&#x2192;',
'rightarrowtail': '&#x21a3;',
'rightharpoondown': '&#x21c1;',
'rightharpoonup': '&#x21c0;',
'rightleftarrows': '&#x21c4;',
'rightleftharpoons': '&#x21cc;',
'rightrightarrows': '&#x21c9;',
'rightsquigarrow': '&#x219d;',
'rightthreetimes': '&#x22cc;',
'ring': '&#x02DA;',
'ringb': '&#x0325;',
'risingdotseq': '&#x2253;',
'rlarr': '&#x21c4;',
'rlhar': '&#x21cc;',
'rlig': '&#xFE21;',
'rlm': '&#x200f;',
'rmacrb': '&#x1E5F;',
'rmoust': '&#x23b1;',
'rmoustache': '&#x23b1;',
'rnmid': '&#x2aee;',
'roang': '&#x27ed;',
'roarr': '&#x21fe;',
'robrk': '&#x27e7;',
'ropar': '&#x2986;',
'ropf': '&#x1d563;',
'roplus': '&#x2a2e;',
'rotimes': '&#x2a35;',
'rpar': r')',
'rpargt': '&#x2994;',
'rppolint': '&#x2a12;',
'rrarr': '&#x21c9;',
'rsaquo': '&#x203a;',
'rscr': '&#x1d4c7;',
'rsh': '&#x21b1;',
'rsqb': r']',
'rsquo': '&#x2019;',
'rsquor': '&#x2019;',
'rthree': '&#x22cc;',
'rtimes': '&#x22ca;',
'rtri': '&#x25b9;',
'rtrie': '&#x22b5;',
'rtrif': '&#x25b8;',
'rtriltri': '&#x29ce;',
'ruluhar': '&#x2968;',
'rx': '&#x211e;',
'sacute': '&#x015B;',
'sacuteda': '&#x1E65;',
'sbquo': '&#x201a;',
'sc': '&#x227b;',
'scE': '&#x2ab4;',
'scap': '&#x2ab8;',
'scaron': '&#x0161;',
'scaronda': '&#x1E67;',
'sccue': '&#x227d;',
'sce': '&#x2ab0;',
'scedil': '&#x015F;',
'scirc': '&#x015D;',
'scnE': '&#x2ab6;',
'scnap': '&#x2aba;',
'scnsim': '&#x22e9;',
'scommab': '&#x0219;',
'scpolint': '&#x2a13;',
'scriptl': '&#x2113;',
'scsim': '&#x227f;',
'scy': '&#x0441;',
'sdot': '&#x22c5;',
'sdota': '&#x1E61;',
'sdotb': '&#x22a1;',
'sdotbda': '&#x1E69;',
'sdote': '&#x2a66;',
'seArr': '&#x21d8;',
'searhk': '&#x2925;',
'searr': '&#x2198;',
'searrow': '&#x2198;',
'sect': r'\xa7',
'semi': r';',
'seswar': '&#x2929;',
'setminus': '&#x2216;',
'setmn': '&#x2216;',
'sext': '&#x2736;',
'sfgr': '&#x03C2;',
'sfr': '&#x1d530;',
'sfrown': '&#x2322;',
'sgr': '&#x03c3;',
'sharp': '&#x266f;',
'shchcy': '&#x0449;',
'shcy': '&#x0448;',
'shortmid': '&#x2223;',
'shortparallel': '&#x2225;',
'shy': r'\xad',
'sigma': '&#x03C3;',
'sigmaf': '&#x03c2;',
'sigmav': '&#x03C2;',
'sim': '&#x223c;',
'simdot': '&#x2a6a;',
'sime': '&#x2243;',
'simeq': '&#x2243;',
'simg': '&#x2a9e;',
'simgE': '&#x2aa0;',
'siml': '&#x2a9d;',
'simlE': '&#x2a9f;',
'simne': '&#x2246;',
'simplus': '&#x2a24;',
'simrarr': '&#x2972;',
'slarr': '&#x2190;',
'smallsetminus': '&#x2216;',
'smashp': '&#x2a33;',
'smeparsl': '&#x29e4;',
'smid': '&#x2223;',
'smile': '&#x2323;',
'smt': '&#x2aaa;',
'smte': '&#x2aac;',
'smtes': '&#x2aac;&#xfe00;',
'softcy': '&#x044c;',
'softsign': '&#x02B9;',
'sol': r'/',
'solb': '&#x29c4;',
'solbar': '&#x233f;',
'sopf': '&#x1d564;',
'spades': '&#x2660;',
'spadesuit': '&#x2660;',
'spar': '&#x2225;',
'sqcap': '&#x2293;',
'sqcaps': '&#x2293;&#xfe00;',
'sqcup': '&#x2294;',
'sqcups': '&#x2294;&#xfe00;',
'sqsub': '&#x228f;',
'sqsube': '&#x2291;',
'sqsubset': '&#x228f;',
'sqsubseteq': '&#x2291;',
'sqsup': '&#x2290;',
'sqsupe': '&#x2292;',
'sqsupset': '&#x2290;',
'sqsupseteq': '&#x2292;',
'squ': '&#x25a1;',
'square': '&#x25a1;',
'squarf': '&#x25aa;',
'squf': '&#x25aa;',
'srarr': '&#x2192;',
'sscr': '&#x1d4c8;',
'ssetmn': '&#x2216;',
'ssmile': '&#x2323;',
'sstarf': '&#x22c6;',
'star': '&#x2606;',
'starf': '&#x2605;',
'straightepsilon': '&#x03f5;',
'straightphi': '&#x03d5;',
'strns': r'\xaf',
'sub': '&#x2282;',
'sub0': '&#x2080;',
'sub1': '&#x2081;',
'sub2': '&#x2082;',
'sub3': '&#x2083;',
'sub4': '&#x2084;',
'sub5': '&#x2085;',
'sub6': '&#x2086;',
'sub7': '&#x2087;',
'sub8': '&#x2088;',
'sub9': '&#x2089;',
'subE': '&#x2ac5;',
'subdot': '&#x2abd;',
'sube': '&#x2286;',
'subedot': '&#x2ac3;',
'sublpar': '&#x208D;',
'subminus': '&#x208B;',
'submult': '&#x2ac1;',
'subnE': '&#x2acb;',
'subne': '&#x228a;',
'subplus': '&#x2abf;',
'subrarr': '&#x2979;',
'subrpar': '&#x208E;',
'subset': '&#x2282;',
'subseteq': '&#x2286;',
'subseteqq': '&#x2ac5;',
'subsetneq': '&#x228a;',
'subsetneqq': '&#x2acb;',
'subsim': '&#x2ac7;',
'subsub': '&#x2ad5;',
'subsup': '&#x2ad3;',
'succ': '&#x227b;',
'succapprox': '&#x2ab8;',
'succcurlyeq': '&#x227d;',
'succeq': '&#x2ab0;',
'succnapprox': '&#x2aba;',
'succneqq': '&#x2ab6;',
'succnsim': '&#x22e9;',
'succsim': '&#x227f;',
'sum': '&#x2211;',
'sung': '&#x266a;',
'sup': '&#x2283;',
'sup0': '&#x2070;',
'sup1': r'\xb9',
'sup2': r'\xb2',
'sup3': r'\xb3',
'sup4': '&#x2074;',
'sup5': '&#x2075;',
'sup6': '&#x2076;',
'sup7': '&#x2077;',
'sup8': '&#x2078;',
'sup9': '&#x2079;',
'supE': '&#x2ac6;',
'supdot': '&#x2abe;',
'supdsub': '&#x2ad8;',
'supe': '&#x2287;',
'supedot': '&#x2ac4;',
'suphsol': '&#x27c9;',
'suphsub': '&#x2ad7;',
'suplarr': '&#x297b;',
'suplpar': '&#x207D;',
'supminus': '&#x207B;',
'supmult': '&#x2ac2;',
'supnE': '&#x2acc;',
'supne': '&#x228b;',
'supplus': '&#x2ac0;',
'suprpar': '&#x207E;',
'supset': '&#x2283;',
'supseteq': '&#x2287;',
'supseteqq': '&#x2ac6;',
'supsetneq': '&#x228b;',
'supsetneqq': '&#x2acc;',
'supsim': '&#x2ac8;',
'supsub': '&#x2ad4;',
'supsup': '&#x2ad6;',
'swArr': '&#x21d9;',
'swarhk': '&#x2926;',
'swarr': '&#x2199;',
'swarrow': '&#x2199;',
'swnwar': '&#x292a;',
'szlig': r'\xdf',
'target': '&#x2316;',
'tau': '&#x03C4;',
'tbrk': '&#x23b4;',
'tcaron': '&#x0165;',
'tcedil': '&#x0163;',
'tcircti': '&#x1EC5;',
'tcommab': '&#x021B;',
'tcy': '&#x0442;',
'tdot': '&#x20db;',
'tdotb': '&#x1E6D;',
'telrec': '&#x2315;',
'tfr': '&#x1d531;',
'tgr': '&#x03c4;',
'there4': '&#x2234;',
'therefore': '&#x2234;',
'theta': '&#x03B8;',
'thetasym': '&#x03d1;',
'thetav': '&#x03D1;',
'thgr': '&#x03b8;',
'thickapprox': '&#x2248;',
'thicksim': '&#x223c;',
'thinsp': '&#x2009;',
'thkap': '&#x2248;',
'thksim': '&#x223c;',
'thorn': r'\xfe',
'tilde': '&#x02dc;',
'times': r'\xd7',
'timesb': '&#x22a0;',
'timesbar': '&#x2a31;',
'timesd': '&#x2a30;',
'tint': '&#x222d;',
'tmacrb': '&#x1E6F;',
'toea': '&#x2928;',
'top': '&#x22a4;',
'topbot': '&#x2336;',
'topcir': '&#x2af1;',
'topf': '&#x1d565;',
'topfork': '&#x2ada;',
'tosa': '&#x2929;',
'tprime': '&#x2034;',
'trade': '&#x2122;',
'triangle': '&#x25b5;',
'triangledown': '&#x25bf;',
'triangleleft': '&#x25c3;',
'trianglelefteq': '&#x22b4;',
'triangleq': '&#x225c;',
'triangleright': '&#x25b9;',
'trianglerighteq': '&#x22b5;',
'tridot': '&#x25ec;',
'trie': '&#x225c;',
'triminus': '&#x2a3a;',
'triplus': '&#x2a39;',
'trisb': '&#x29cd;',
'tritime': '&#x2a3b;',
'trpezium': '&#x23e2;',
'tscr': '&#x1d4c9;',
'tscy': '&#x0446;',
'tshcy': '&#x045b;',
'tstrok': '&#x0167;',
'tuml': '&#x1E97;',
'twixt': '&#x226c;',
'twoheadleftarrow': '&#x219e;',
'twoheadrightarrow': '&#x21a0;',
'uArr': '&#x21d1;',
'uHar': '&#x2963;',
'uacgr': '&#x03CD;',
'uacute': r'\xfa',
'uarr': '&#x2191;',
'ubrcy': '&#x045e;',
'ubreve': '&#x016D;',
'ucaron': '&#x01D4;',
'ucirc': r'\xfb',
'ucy': '&#x0443;',
'udarr': '&#x21c5;',
'udblac': '&#x0171;',
'udbldb': '&#x1E73;',
'udhar': '&#x296e;',
'udiagr': '&#x03B0;',
'udigr': '&#x03CB;',
'udotb': '&#x1EE5;',
'ufisht': '&#x297e;',
'ufr': '&#x1d532;',
'ugr': '&#x03c5;',
'ugrave': r'\xf9',
'uharl': '&#x21bf;',
'uharr': '&#x21be;',
'uhblk': '&#x2580;',
'uhooka': '&#x1EE7;',
'uhorn': '&#x01B0;',
'uhornac': '&#x1EE9;',
'uhorndb': '&#x1EF1;',
'uhorngr': '&#x1EEB;',
'uhornha': '&#x1EED;',
'uhornti': '&#x1EEF;',
'ulcorn': '&#x231c;',
'ulcorner': '&#x231c;',
'ulcrop': '&#x230f;',
'ultri': '&#x25f8;',
'umacr': '&#x016B;',
'umacrum': '&#x1E7B;',
'uml': r'\xa8',
'under': '&#x0332;',
'uogon': '&#x0173;',
'uopf': '&#x1d566;',
'uparrow': '&#x2191;',
'updownarrow': '&#x2195;',
'upharpoonleft': '&#x21bf;',
'upharpoonright': '&#x21be;',
'uplus': '&#x228e;',
'upsi': '&#x03C5;',
'upsih': '&#x03d2;',
'upsilon': '&#x03c5;',
'upuparrows': '&#x21c8;',
'urcorn': '&#x231d;',
'urcorner': '&#x231d;',
'urcrop': '&#x230e;',
'uring': '&#x016F;',
'urtri': '&#x25f9;',
'uscr': '&#x1d4ca;',
'utdot': '&#x22f0;',
'utilde': '&#x0169;',
'utildeac': '&#x1E79;',
'utri': '&#x25b5;',
'utrif': '&#x25b4;',
'uuarr': '&#x21c8;',
'uuml': r'\xfc',
'uwangle': '&#x29a7;',
'vArr': '&#x21d5;',
'vBar': '&#x2ae8;',
'vBarv': '&#x2ae9;',
'vDash': '&#x22a8;',
'vangrt': '&#x299c;',
'varepsilon': '&#x03f5;',
'varkappa': '&#x03f0;',
'varnothing': '&#x2205;',
'varphi': '&#x03d5;',
'varpi': '&#x03d6;',
'varpropto': '&#x221d;',
'varr': '&#x2195;',
'varrho': '&#x03f1;',
'varsigma': '&#x03c2;',
'varsubsetneq': '&#x228a;&#xfe00;',
'varsubsetneqq': '&#x2acb;&#xfe00;',
'varsupsetneq': '&#x228b;&#xfe00;',
'varsupsetneqq': '&#x2acc;&#xfe00;',
'vartheta': '&#x03d1;',
'vartriangleleft': '&#x22b2;',
'vartriangleright': '&#x22b3;',
'vcy': '&#x0432;',
'vdash': '&#x22a2;',
'vdotb': '&#x1E7F;',
'vee': '&#x2228;',
'veebar': '&#x22bb;',
'veeeq': '&#x225a;',
'vellip': '&#x22ee;',
'verbar': r'|',
'vert': r'|',
'vfr': '&#x1d533;',
'vltri': '&#x22b2;',
'vnsub': '&#x2282;&#x20d2;',
'vnsup': '&#x2283;&#x20d2;',
'vopf': '&#x1d567;',
'vprop': '&#x221d;',
'vrtri': '&#x22b3;',
'vscr': '&#x1d4cb;',
'vsubnE': '&#x2acb;&#xfe00;',
'vsubne': '&#x228a;&#xfe00;',
'vsupnE': '&#x2acc;&#xfe00;',
'vsupne': '&#x228b;&#xfe00;',
'vtilde': '&#x1E7D;',
'vzigzag': '&#x299a;',
'wacute': '&#x1E83;',
'wcirc': '&#x0175;',
'wdot': '&#x1E87;',
'wdotb': '&#x1E89;',
'wedbar': '&#x2a5f;',
'wedge': '&#x2227;',
'wedgeq': '&#x2259;',
'weierp': '&#x2118;',
'wfr': '&#x1d534;',
'wgrave': '&#x1E81;',
'wopf': '&#x1d568;',
'wp': '&#x2118;',
'wr': '&#x2240;',
'wreath': '&#x2240;',
'wring': '&#x1E98;',
'wscr': '&#x1d4cc;',
'wuml': '&#x1E85;',
'xcap': '&#x22c2;',
'xcirc': '&#x25ef;',
'xcup': '&#x22c3;',
'xdot': '&#x1E8B;',
'xdtri': '&#x25bd;',
'xfr': '&#x1d535;',
'xgr': '&#x03be;',
'xhArr': '&#x27fa;',
'xharr': '&#x27f7;',
'xi': '&#x03BE;',
'xlArr': '&#x27f8;',
'xlarr': '&#x27f5;',
'xmap': '&#x27fc;',
'xnis': '&#x22fb;',
'xodot': '&#x2a00;',
'xopf': '&#x1d569;',
'xoplus': '&#x2a01;',
'xotime': '&#x2a02;',
'xrArr': '&#x27f9;',
'xrarr': '&#x27f6;',
'xscr': '&#x1d4cd;',
'xsqcup': '&#x2a06;',
'xuml': '&#x1E8D;',
'xuplus': '&#x2a04;',
'xutri': '&#x25b3;',
'xvee': '&#x22c1;',
'xwedge': '&#x22c0;',
'yacute': r'\xfd',
'yacy': '&#x044f;',
'ycirc': '&#x0177;',
'ycy': '&#x044b;',
'ydot': '&#x1E8F;',
'ydotb': '&#x1EF5;',
'yen': r'\xa5',
'yfr': '&#x1d536;',
'ygrave': '&#x1EF3;',
'yhooka': '&#x1EF7;',
'yicy': '&#x0457;',
'ymacr': '&#x0233;',
'yopf': '&#x1d56a;',
'yring': '&#x1E99;',
'yscr': '&#x1d4ce;',
'ytilde': '&#x1EF9;',
'yucy': '&#x044e;',
'yuml': r'\xff',
'zacute': '&#x017A;',
'zcaron': '&#x017E;',
'zcirc': '&#x1E91;',
'zcy': '&#x0437;',
'zdot': '&#x017C;',
'zdotb': '&#x1E93;',
'zeetrf': '&#x2128;',
'zeta': '&#x03B6;',
'zfr': '&#x1d537;',
'zgr': '&#x03b6;',
'zhcy': '&#x0436;',
'zigrarr': '&#x21dd;',
'zlowline': '&#x1E95;',
'zopf': '&#x1d56b;',
'zscr': '&#x1d4cf;',
'zwj': '&#x200d;',
'zwnj': '&#x200c;',
}
