/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.iterators.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(XMLIterator.class);
    private ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    private ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    private ThreadLocal<XMLEventFactory> eventFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newInstance();
        }
    };
    public static final String UTF_8 = "UTF-8";
    final XMLEventReader parser;
    private XMLEvent current = null;
    private String element;
    private InputStream inputStream;

    public XMLIterator(String element, InputStream inputStream) {
        this.element = element;
        this.inputStream = inputStream;
        this.parser = this.getParser();
        try {
            this.current = this.findElement(this.parser);
        }
        catch (XMLStreamException e) {
            log.warn((Object)("cannot init parser position. No element found: " + element));
            this.current = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public String next() {
        String result = null;
        try {
            result = this.copy(this.parser);
            this.current = this.findElement(this.parser);
            return result;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(String.format("error copying xml, built so far: '%s'", result), e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copy(XMLEventReader parser) throws XMLStreamException {
        StringWriter result = new StringWriter();
        try {
            XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(result);
            StartElement newRecord = this.eventFactory.get().createStartElement("", null, this.element, this.current.asStartElement().getAttributes(), null);
            writer.add(newRecord);
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(this.element)) {
                    writer.add(event);
                    break;
                }
                writer.add(event);
            }
            writer.close();
        }
        finally {
            return result.toString();
        }
    }

    private XMLEvent findElement(XMLEventReader parser) throws XMLStreamException {
        String name;
        XMLEvent peek = parser.peek();
        if (peek != null && peek.isStartElement() && this.element.equals(name = peek.asStartElement().getName().getLocalPart())) {
            return peek;
        }
        while (parser.hasNext()) {
            String name2;
            XMLEvent event = parser.nextEvent();
            if (event == null || !event.isStartElement() || !this.element.equals(name2 = event.asStartElement().getName().getLocalPart())) continue;
            return event;
        }
        return null;
    }

    private XMLEventReader getParser() {
        try {
            return this.inputFactory.get().createXMLEventReader(this.sanitize(this.inputStream));
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private Reader sanitize(InputStream in) {
        CharsetDecoder charsetDecoder = Charset.forName(UTF_8).newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new InputStreamReader(in, charsetDecoder);
    }
}

