/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.cache;

import eu.dnetlib.miscutils.cache.Cache;
import eu.dnetlib.miscutils.cache.CacheElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;

public class EhCache<K, V>
implements Cache<K, V> {
    private net.sf.ehcache.Cache cache;

    public EhCache() {
    }

    public EhCache(net.sf.ehcache.Cache ehCache) {
        this.basicSetCache(ehCache);
    }

    @Override
    public V get(Object key) {
        CacheElement<V> element = this.getElement(key);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    @Override
    public CacheElement<V> getElement(K key) {
        Element element = this.cache.get(key);
        if (element == null) {
            return null;
        }
        CacheElement<Object> res = new CacheElement<Object>(element.getObjectValue());
        res.setTimeToLive(element.getTimeToLive());
        res.setTimeToLive(element.getTimeToIdle());
        res.setCreationTime(element.getCreationTime());
        res.setSpecificElement(element);
        return res;
    }

    @Override
    public V put(K key, CacheElement<V> element) {
        boolean eternal;
        boolean bl = eternal = element.getTimeToLive() == 0;
        if (eternal) {
            this.cache.put(new Element(key, element.getValue(), eternal));
        } else {
            this.cache.put(new Element(key, element.getValue(), element.getTimeToLive().intValue(), element.getTimeToIdle().intValue()));
        }
        return element.getValue();
    }

    @Override
    public V put(K key, V value) {
        return (V)this.put(key, (V)new CacheElement<V>(value));
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.cache.isKeyInCache(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.cache.isValueInCache(arg0);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> res = new HashSet<Map.Entry<K, V>>();
        for (K key : this.keySet()) {
            res.add(new MapEntry(key));
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return new HashSet(this.cache.getKeys());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
        for (Map.Entry<K, V> entry : arg0.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object arg0) {
        V val = this.get(arg0);
        this.cache.remove(arg0);
        return val;
    }

    @Override
    public int size() {
        return this.cache.getSize();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> res = new ArrayList<V>();
        for (K key : this.keySet()) {
            res.add(this.get(key));
        }
        return res;
    }

    public net.sf.ehcache.Cache getCache() {
        return this.cache;
    }

    public void setCache(net.sf.ehcache.Cache cache) {
        this.basicSetCache(cache);
    }

    private void basicSetCache(net.sf.ehcache.Cache cache) {
        this.cache = cache;
    }

    public class MapEntry
    implements Map.Entry<K, V> {
        transient K key;

        MapEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return EhCache.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return EhCache.this.put(this.key, value);
        }
    }
}

