/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareActionSetsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareActionSetsJobNode.class);
    private String sets;

    protected String execute(NodeToken token) throws Exception {
        List<Map<String, String>> setList = this.getSetList();
        String now = DateUtils.now_ISO8601();
        for (Map<String, String> set : setList) {
            set.put("rawset", RawSet.newInstance().getId());
            set.put("creationDate", now);
            if (set.get("enabled").equals("true")) {
                log.info((Object)("preparing set: " + this.simplifySetInfo(set)));
            }
            token.getEnv().setAttribute(set.get("jobProperty"), set.get("rawset"));
        }
        token.getEnv().setAttribute("sets", new Gson().toJson(setList));
        return Arc.DEFAULT_ARC;
    }

    private Map<String, String> simplifySetInfo(Map<String, String> set) {
        return Maps.filterKeys(set, (Predicate)new Predicate<String>(){

            public boolean apply(String k) {
                return k.equals("set") || k.equals("rawset");
            }
        });
    }

    protected List<Map<String, String>> getSetList() {
        return (List)new Gson().fromJson(this.getSets(), List.class);
    }

    public String getSets() {
        return this.sets;
    }

    public void setSets(String sets) {
        this.sets = sets;
    }
}

