/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareMDStoreImportJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareMDStoreImportJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String hdfsPathParam;
    private String hdfsPath;
    private String mappingParam;
    private String mapping;

    protected String execute(NodeToken token) throws Exception {
        token.getEnv().setAttribute(this.getHdfsPathParam(), this.getHdfsPath());
        token.getEnv().setAttribute(this.getMappingParam(), this.readXslt(this.getMapping()));
        return Arc.DEFAULT_ARC;
    }

    private String readXslt(String profileId) throws IOException, MSROException, ISLookUpDocumentNotFoundException, ISLookUpException {
        if (StringUtils.isBlank((String)profileId)) {
            throw new MSROException("missing profile id");
        }
        log.info((Object)("loading mapping from profile id: " + profileId));
        String xquery = String.format("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']", profileId);
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
    }

    public String getHdfsPathParam() {
        return this.hdfsPathParam;
    }

    public void setHdfsPathParam(String hdfsPathParam) {
        this.hdfsPathParam = hdfsPathParam;
    }

    public String getHdfsPath() {
        return this.hdfsPath;
    }

    public void setHdfsPath(String hdfsPath) {
        this.hdfsPath = hdfsPath;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getMappingParam() {
        return this.mappingParam;
    }

    public void setMappingParam(String mappingParam) {
        this.mappingParam = mappingParam;
    }
}

