package eu.dnetlib.msro.workflows.actions;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class PromoteActionsJobNode extends BlackboardJobNode {

	public static final String ALL_SETS = "ALL SETS";

	private String set;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(ActionManagerService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction("PROMOTE");
		if (set != null && !set.isEmpty() && !set.equals(ALL_SETS)) {
			job.getParameters().put("set", set);
		}
	}

	public String getSet() {
		return set;
	}

	public void setSet(final String set) {
		this.set = set;
	}

}
