package eu.dnetlib.msro.workflows.dedup;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestrationLoader;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

public class DedupConfigurationSetterJobNode extends AsyncJobNode {

	private String dedupConfigSequence;

	private String dedupConfigSequenceParam;

	@Autowired
	private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		if (StringUtils.isBlank(getDedupConfigSequence())) throw new IllegalArgumentException("missing configuration sequence");

		final DedupConfigurationOrchestration dedupOrchestration = dedupOrchestrationLoader.load(getDedupConfigSequence());

		token.getEnv().setAttribute("entityType", dedupOrchestration.getEntity().getName());
		token.getEnv().setAttribute("entityTypeId", dedupOrchestration.getEntity().getCode());

		token.getEnv().setAttribute(getDedupConfigSequenceParam(), dedupOrchestration.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getDedupConfigSequence() {
		return dedupConfigSequence;
	}

	public void setDedupConfigSequence(final String dedupConfigSequence) {
		this.dedupConfigSequence = dedupConfigSequence;
	}

	public String getDedupConfigSequenceParam() {
		return dedupConfigSequenceParam;
	}

	public void setDedupConfigSequenceParam(final String dedupConfigSequenceParam) {
		this.dedupConfigSequenceParam = dedupConfigSequenceParam;
	}

}
