package eu.dnetlib.msro.workflows.hadoop.hbase;

import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopService;

public class CreateHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(CreateHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final Set<String> columns = getColumns(token);
		final String tableName = tableName(token);
		final String cluster = cluster(token);

		log.info("Ensuring table " + tableName + " on cluster: '" + cluster + "' - columns: " + columns);

		getServiceLocator().getService(HadoopService.class).createHbaseTable(cluster, tableName, columns);

		return Arc.DEFAULT_ARC;
	}

}
