package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;

public class ListHBaseTables extends ValidNodeValuesFetcher {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ListHBaseTables.class);

	@Resource
	private UniqueServiceLocator serviceLocator;

	private Function<String, DnetParamValue> f = new Function<String, DnetParamValue>() {

		@Override
		public DnetParamValue apply(final String s) {

			return new DnetParamValue(s, s);
		}
	};

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {
		List<DnetParamValue> res = Lists.newArrayList(Iterables.transform(listTables(params.get("cluster")), f));
		return res;
	}

	private List<String> listTables(final String cluster) {
		try {
			log.info("list tables for cluster: " + cluster);
			return serviceLocator.getService(HadoopService.class).listHbaseTables(cluster);
		} catch (Throwable e) {
			log.error(e);
			return Lists.newArrayList();
		}
	}
}
