package eu.dnetlib.msro.workflows.hadoop;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

/**
 * The Class SetClusterAndTableJobNode.
 */
public class SetClusterAndTableJobNode extends AsyncJobNode {

	/** The cluster. */
	private String cluster;

	/** The table. */
	private String table;

	/** The table param. */
	private String tableParam;

	/** The service locator. */
	@Resource
	private UniqueServiceLocator serviceLocator;

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.msro.workflows.nodes.AsyncJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {

		if (StringUtils.isBlank(getCluster())) throw new IllegalArgumentException("missing cluster name parameter");
		if (StringUtils.isBlank(getTable())) throw new IllegalArgumentException("missing table name parameter");
		if (!serviceLocator.getService(HadoopService.class).existHbaseTable(getCluster(), getTable()))
			throw new IllegalArgumentException(String.format("unexisting table %s on cluster %s", getTable(), getCluster()));

		token.getEnv().setAttribute("cluster", getCluster());
		token.getEnv().setAttribute(getTableParam(), getTable());

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the cluster.
	 *
	 * @return the cluster
	 */
	public String getCluster() {
		return cluster;
	}

	/**
	 * Sets the cluster.
	 *
	 * @param cluster
	 *            the new cluster
	 */
	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

	/**
	 * Gets the table.
	 *
	 * @return the table
	 */
	public String getTable() {
		return table;
	}

	/**
	 * Sets the table.
	 *
	 * @param table
	 *            the new table
	 */
	public void setTable(final String table) {
		this.table = table;
	}

	/**
	 * Gets the table param.
	 *
	 * @return the table param
	 */
	public String getTableParam() {
		return tableParam;
	}

	/**
	 * Sets the table param.
	 *
	 * @param tableParam
	 *            the new table param
	 */
	public void setTableParam(final String tableParam) {
		this.tableParam = tableParam;
	}

}
