/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestrationLoader;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class PrepareDedupIndexJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareDedupIndexJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;
    private String rottenRecordsPathParam;
    private String hbaseTable;
    private String dedupConfig;

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"start preparing job");
        String fields = this.getFields(this.env("format", token), this.env("layout", token));
        token.getEnv().setAttribute("index.fields", fields);
        if (!StringUtils.isBlank((String)this.getRottenRecordsPathParam())) {
            token.getEnv().setAttribute(this.getRottenRecordsPathParam(), "/tmp" + this.getFileName(token, "rottenrecords"));
        }
        token.getEnv().setAttribute("index.solr.url", this.getIndexSolrUrlZk());
        token.getEnv().setAttribute("index.solr.collection", this.getCollectionName(token));
        token.getEnv().setAttribute("index.shutdown.wait.time", this.getIndexSolrShutdownWait());
        token.getEnv().setAttribute("index.buffer.flush.threshold", this.getIndexBufferFlushTreshold());
        token.getEnv().setAttribute("index.solr.sim.mode", this.isFeedingSimulationMode());
        token.getEnv().setAttribute("index.feed.timestamp", DateUtils.now_ISO8601());
        DedupConfigurationOrchestration conf = this.dedupConfigurations(token);
        token.getEnv().setAttribute("actionset", conf.getActionSetId());
        token.getEnv().setAttribute("entityType", conf.getEntity().getName());
        token.getEnv().setAttribute("entityTypeId", conf.getEntity().getCode());
        return Arc.DEFAULT_ARC;
    }

    private DedupConfigurationOrchestration dedupConfigurations(NodeToken token) throws ISLookUpDocumentNotFoundException, ISLookUpException, DocumentException {
        if (this.getDedupConfig() == null || this.getDedupConfig().trim().isEmpty()) {
            throw new IllegalStateException("Cannot find dedup configurations in workflow env: '" + this.getDedupConfig() + "'");
        }
        return this.dedupOrchestrationLoader.load(this.getDedupConfig());
    }

    private String getFields(String format, String layout) throws ISLookUpException {
        return this.isLookup(String.format("<FIELDS>{for $x in collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='%s']//LAYOUT[@name='%s']/FIELDS/FIELD return $x[string(@path)]}</FIELDS>", format, layout));
    }

    public String getIndexSolrUrlZk() throws ISLookUpException {
        return this.isLookup("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='solr']/@address/string()");
    }

    public String getIndexSolrShutdownWait() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingShutdownTolerance");
    }

    public String getIndexBufferFlushTreshold() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingBufferFlushThreshold");
    }

    public String isFeedingSimulationMode() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingSimulationMode");
    }

    private String queryForServiceProperty(String key) throws ISLookUpException {
        return this.isLookup("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + key + "']/@value/string()");
    }

    private String isLookup(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        String res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
        if (StringUtils.isBlank((String)res)) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return res;
    }

    private String getFileName(NodeToken token, String fileNamePrefix) {
        return "/" + fileNamePrefix + "_" + this.getHbaseTable() + "_" + token.getEnv().getAttribute("format") + ".seq";
    }

    private String getCollectionName(NodeToken token) {
        return this.env("format", token) + "-" + this.env("layout", token) + "-" + this.env("interpretation", token);
    }

    private String env(String s, NodeToken token) {
        return token.getEnv().getAttribute(s);
    }

    public String getHbaseTable() {
        return this.hbaseTable;
    }

    @Required
    public void setHbaseTable(String hbaseTable) {
        this.hbaseTable = hbaseTable;
    }

    public String getRottenRecordsPathParam() {
        return this.rottenRecordsPathParam;
    }

    public void setRottenRecordsPathParam(String rottenRecordsPathParam) {
        this.rottenRecordsPathParam = rottenRecordsPathParam;
    }

    public String getDedupConfig() {
        return this.dedupConfig;
    }

    public void setDedupConfig(String dedupConfig) {
        this.dedupConfig = dedupConfig;
    }
}

