/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup.conf;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.dedup.conf.Entity;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DedupConfigurationOrchestrationLoader {
    private static final Log log = LogFactory.getLog(DedupConfigurationOrchestrationLoader.class);
    @Resource
    private UniqueServiceLocator serviceLocator;

    public DedupConfigurationOrchestration load(String id) throws ISLookUpDocumentNotFoundException, ISLookUpException, DocumentException {
        ISLookUpService isLookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String xquery = String.format("/RESOURCE_PROFILE[.//DEDUPLICATION/ACTION_SET/@id = '%s']", id);
        log.info((Object)("loading dedup orchestration: " + xquery));
        String dedupOrchestation = isLookUpService.getResourceProfileByQuery(xquery);
        Document doc = new SAXReader().read((Reader)new StringReader(dedupOrchestation));
        Element e = (Element)doc.selectSingleNode("//DEDUPLICATION/ENTITY");
        Entity entity = new Entity(e.attributeValue("name"), e.attributeValue("code"), e.attributeValue("label"));
        String actionSetId = doc.valueOf("//DEDUPLICATION/ACTION_SET/@id");
        LinkedList configurations = Lists.newLinkedList();
        for (Object o : doc.selectNodes("//SCAN_SEQUENCE/SCAN")) {
            Element s = (Element)o;
            String configProfileId = s.attributeValue("id");
            String conf = isLookUpService.getResourceProfileByQuery(String.format("for $x in /RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '%s'] return $x//DEDUPLICATION/text()", configProfileId));
            DedupConfig dedupConfig = DedupConfig.load((String)conf);
            dedupConfig.getWf().setConfigurationId(actionSetId);
            configurations.add(dedupConfig);
        }
        DedupConfigurationOrchestration dco = new DedupConfigurationOrchestration(entity, actionSetId, configurations);
        log.debug((Object)("loaded dedup configuration orchestration: " + dco.toString()));
        log.info((Object)("loaded dedup configuration orchestration, size: " + dco.getConfigurations().size()));
        return dco;
    }
}

