package eu.dnetlib.msro.workflows.hadoop.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopService;

/**
 * The Class DropHBaseTableJobNode.
 */
public class DropHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(DropHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String tableName = tableName(token);
		final String cluster = cluster(token);

		log.info("Dropping hbase table '" + tableName + "' on cluster: '" + cluster + "'");

		getServiceLocator().getService(HadoopService.class).dropHbaseTable(cluster, tableName);

		return Arc.DEFAULT_ARC;
	}

}
