var module = angular.module('dedupInspector', ['ngRoute', 'dedupInspectorControllers']);

module.run(function($rootScope) {
	$rootScope.Utils = {
		keys : Object.keys,
		values : Object.values
	}
});	

module.config([
	'$routeProvider',
	function($routeProvider) {
		$routeProvider
			.when('/add/:entityType',							{ templateUrl: '../resources/html/dedup/add.html', controller: 'addSimRelsCtrl' })
			.when('/add/:entityType/:actionSet',				{ templateUrl: '../resources/html/dedup/add.html', controller: 'addSimRelsCtrl' })
			.when('/add/:entityType/:actionSet/:query/:start',	{ templateUrl: '../resources/html/dedup/add.html', controller: 'addSimRelsCtrl' });
			//.otherwise({ redirectTo: '/manage/all/0/10' });
	}
]);

module.controller('moduleMenuCtrl', [ '$scope', '$location',  
	function ($scope, $location) {
		$scope.isActive = function(regex) {
			var re = new RegExp(regex);
			return re.test($location.path());
		}
	}
]);

module.directive('bsHasError', function() {
	return {
		restrict: "A",
		link: function(scope, element, attrs, ctrl) {
			element.toggleClass('has-feedback', true);
			var input = element.find('input[ng-model], select[ng-model]');
			if (input) {
				scope.$watch(function() {
					if (input.hasClass('ng-invalid')) {
						return 0;
					} else if (input.hasClass('empty')) {
						return 1;
					} else {
						return 2;
					}
				}, function(code) {
					if (code < 0) return;
					
					element.toggleClass('has-error', (code == 0));
					element.toggleClass('has-warning', (code == 1));
					element.toggleClass('has-success', (code == 2));
					
					var feedback = element.find('.form-control-feedback');
					if (feedback) {
						feedback.toggleClass('glyphicon-remove', (code == 0));
						feedback.toggleClass('glyphicon-warning-sign', (code == 1));
						feedback.toggleClass('glyphicon-ok', (code == 2));
					}
				});
			}
		}
	};
});

module.directive('compileTemplate', function($compile, $parse){
    return {
        link: function(scope, element, attr) {
            var parsed = $parse(attr.ngBindHtml);

            function getStringValue() { return (parsed(scope) || '').toString(); }

            //Recompile if the template changes
            scope.$watch(getStringValue, function() {
            	$compile(element, null, -9999)(scope);  //The -9999 makes it skip directives so that we do not recompile ourselves
            });
        }
    }
});

module.directive('ngDedupRecordsTable', function() {
	return {
		restrict: 'E',
		scope: {
            'theads'  : '@',
            'fields'  : '@',
            'results' : '=',
            'group'	  : '=',
            
            'showMergedFn' : '=',
            'addToGroupFn' : '=',
            'removeFromGroupFn' : '=',
            'removeFromGroupAndDeassociateFn' : '=',
		},
		templateUrl: '../resources/html/dedup/recordTable.html', 
		link: function(scope, element, attrs, ctrl) {
			scope.headers = scope.theads.split(",");
			scope.fnames = scope.fields.split(",");

			scope.containsList = function(idList, set) {
				var res = true;
				if (idList && set && set.length > 0) {
					var ids = idList.split(",");
					angular.forEach(ids, function(id) {
						if(jQuery.grep(set, function(val, i) {
							  return val == id;
						}).length == 0) {
					    	res = false;
					    	return;
						};
					});
				} else {
					return false;
				}
				return res;
			}
		}
	}
});

module.service('groupService', function () {
    var group = null;
    var dissimilar = null;
    return {
        getGroup:	function ()     { return group; },
        setGroup:	function (g)    { group = g; },
        
        getDissimilar:	function ()		{ return dissimilar; },
        setDissimilar:	function (d)	{ dissimilar = d; }            
    };
});



