package eu.dnetlib.functionality.modular.ui.dedup;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;

public class DedupServiceEntryPointController extends ModuleEntryPoint {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected void initialize(final ModelMap map, final HttpServletRequest request, final HttpServletResponse response) throws Exception {

		final ISLookUpService lookUpService = serviceLocator.getService(ISLookUpService.class);
		final String listEntityTypesXQuery =
				"distinct-values(for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType'] return $x//ENTITY/@name/string())";

		for (final String entityType : lookUpService.quickSearchProfile(listEntityTypesXQuery)) {
			final String xquery =
					String.format(
							"for $x in //RESOURCE_PROFILE[" +
									".//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//ENTITY/@name='%s' ] " +
									"return $x//ACTION_SET/@id/string()", entityType);
			map.put(entityType, lookUpService.quickSearchProfile(xquery));
		}

	}

}
