/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class SetClusterAndTableJobNode
extends AsyncJobNode {
    private String cluster;
    @Value(value="${hbase.mapred.datatable}")
    private String table;
    private String tableParam;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(NodeToken token) throws Exception {
        if (StringUtils.isBlank((String)this.getCluster())) {
            throw new IllegalArgumentException("missing cluster name parameter");
        }
        if (StringUtils.isBlank((String)this.table)) {
            throw new IllegalArgumentException("missing table name parameter");
        }
        if (!((HadoopService)this.serviceLocator.getService(HadoopService.class)).existHbaseTable(this.getCluster(), this.table)) {
            throw new IllegalArgumentException(String.format("unexisting table %s on cluster %s", this.table, this.getCluster()));
        }
        token.getEnv().setAttribute("cluster", this.getCluster());
        token.getEnv().setAttribute(this.getTableParam(), this.table);
        return Arc.DEFAULT_ARC;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getTableParam() {
        return this.tableParam;
    }

    public void setTableParam(String tableParam) {
        this.tableParam = tableParam;
    }
}

