<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetDbToHbaseXsltFunctions">
	
	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:template match="/">
	
		<xsl:variable name="source" select="/SIMILARITY/SOURCE/@id" />
		<xsl:variable name="target" select="/SIMILARITY/TARGET/@id" />
		<xsl:variable name="type" select="/SIMILARITY/TYPE/@name" />

		<xsl:variable name="columnFamily">
			<xsl:choose>
				<xsl:when test="$type = 'result'">resultResult_dedupSimilarity_isSimilarTo</xsl:when>
				<xsl:when test="$type = 'person'">personPerson_dedupSimilarity_isSimilarTo</xsl:when>
				<xsl:when test="$type = 'organization'">organizationOrganization_dedupSimilarity_isSimilarTo</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<ROWS>
			<xsl:if test="string-length($source) &gt; 0 and string-length($target) &gt; 0 and string-length($columnFamily) &gt; 0">
				<ROW key="{$source}" columnFamily="{$columnFamily}">
					<QUALIFIER name="{$target}" type="base64"></QUALIFIER>
				</ROW>
			</xsl:if>
		</ROWS>
	
	</xsl:template>

</xsl:stylesheet>
