var dedupInspectorControllers = angular.module('dedupInspectorControllers', []);

function common_init($scope, $http, $sce, $location) {
	initSpinner();
	$scope.showError        = function(error)   { show_notification("error", error); }
	$scope.showNotification = function(message) { show_notification("info", message); }
	$scope.showSpinner      = function()        { showSpinner(); }
	$scope.hideSpinner      = function()        { hideSpinner(); }
	$scope.to_trusted       = function(html)    { return $sce.trustAsHtml(html); }
	$scope.go               = function(path)    { document.location.href='#'+path; }
	$scope.encodeValue      = function(val)     { return val; }
	
	
	$scope.encodeDateParam = function(date) {
		var year = date.getFullYear();
		var month = ("00" + (date.getMonth() + 1)).slice(-2);
		var day = ("00" + date.getDate()).slice(-2);
		return year + month + day;
	}

	$scope.decodeDateParam = function(s) {
		var year = s.substring(0,4);
		var month = s.substring(4,6);
		var day = s.substring(6,8);

		return new Date(year,month-1,day);
	}
}

dedupInspectorControllers.controller('addSimRelsCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams', 'groupService',
	function ($scope, $http, $sce, $location, $routeParams, groupService) {
	
		common_init($scope, $http, $sce, $location);
	
		$scope.validentityTypes = { 
			'result' 		: 	{id:'50', type:'result', label:'Publication'}, 
			'organization' 	: 	{id:'20', type:'organization', label:'Organization'},
			'person' 		: 	{id:'30', type:'person', label:'Person'} 
		};
		$scope.group = groupService.getGroup();
		$scope.dissimilar = groupService.getDissimilar();
		
		if ($scope.group == null || $scope.group.entityType.type != $scope.validentityTypes[$routeParams.entityType].type) {
			$scope.group = {
				actionSet : $routeParams.actionSet,
				details : {},
				byRoot : {},
				byMerged : {},
				group : [],
				rootIds : [],
				detailList : [],
				rootList : [],
				entityType : $scope.validentityTypes[$routeParams.entityType]
			}
			groupService.setGroup($scope.group);
		};
		
		$scope.group.actionSet = $routeParams.actionSet;
		
		if($scope.dissimilar == null || $scope.group.entityType.type != $scope.validentityTypes[$routeParams.entityType].type) {
			$scope.dissimilar = {
				group : {},
				entityType : $scope.validentityTypes[$routeParams.entityType]
			};
			groupService.setDissimilar($scope.dissimilar);
		}

		$scope.groupIdDetails = {
			map : {},
			list : []
		};
		
		if($routeParams.query && $routeParams.query.length > 0) {
			$scope.query = $routeParams.query;
		}
		if($routeParams.start) {
			$scope.start = parseInt($routeParams.start);
		} else {
			$scope.start = 0;
		}
		$scope.rows = 20;
	
		$scope.search = function() {
			$scope.showSpinner();
			var q = '';
			if($scope.query.match('^[0-9][0-9]\|.{12}::[a-zA-Z0-9]{32}$')) {
				q = 'objidentifier exact "' + $scope.query + '"';
			} else {
				q = $scope.query;
			}

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('dedup/search.do', $.param({
				'entityType' : $scope.group.entityType.type,
				'query'  	: q,
				'actionSet' : $scope.group.actionSet,
				'start'	 	: $scope.start,
				'rows'	 	: $scope.rows,
				'fields' 	: $scope.defaultFields()
			})).success(function(res) {
            	if(res) {
            		$scope.results = res;
            		$scope.hideSpinner();
            	} else {
                	$scope.hideSpinner();
            		$scope.showError('Registration failed');
            	}
			}).error(function(err) {
				$scope.hideSpinner();
				$scope.showError('Registration failed: ' + err.message);
			});			
		}
		
		$scope.defaultFields = function() {
			switch($scope.group.entityType.type) { 
			  case "result": 
				  return "title,dateofacceptance,description";
			  case "organization": 
				  return "legalname,legalshortname,websiteurl";
			  case "person": 
				  return "fullname";
			  default: 
				  return "";
			}	
		}
		
		$scope.allFields = function() {
			switch($scope.group.entityType.type) { 
			  case "result": 
				  return "title,dateofacceptance,author,description";
			  case "organization": 
				  return "legalname,legalshortname,country,websiteurl";
			  default: 
				  return "";
			}	
		}		
		
		if($scope.query) {
			$scope.search();
		}
		
		$scope.searchById = function(id, type, fields, responseCallback) {
			$http.post('dedup/searchById.do', $.param({
				'entityType' : type,
				'objidentifier' : id,
				'fields' : fields
			})).success(function(res) {
	        	if(res) {
	        		responseCallback(id, res);
	        	} else {
	        		$scope.showError('Unable to query: ' + mId);
	        	}
			}).error(function(err) {
				$scope.showError('Unable to query id "' + mId + '", error: ' + err.message);
			});
		}		
		
		$scope.resetForm = function() {
			if (confirm('Reset group?')) {
				$scope.doResetForm();
			}
		}
		$scope.doResetForm = function() {
			$scope.group.group = [];
			$scope.group.rootIds = [];
			$scope.group.details = {};
			$scope.group.byRoot = {};
			$scope.group.byMerged = {};
			$scope.group.rootList = [];
			$scope.group.detailList = [];
			
			$scope.groupIdDetails.map = {};
			$scope.groupIdDetails.list = [];

			$scope.dissimilar = {
				group : {},
				entityType : $scope.validentityTypes[$routeParams.entityType]
			};
		}
				
		$scope.commit = function() {
			if (confirm('Commit actions?')) {
				$scope.showSpinner();
				var g = {
					actionSet : $scope.group.actionSet,
					entityType : $scope.group.entityType,
					group : $scope.group.group,
					rootIds : $scope.group.rootIds,
					dissimilar : $scope.dissimilar.group
				}
				$http.defaults.headers.post["Content-Type"] = "application/json; charset=UTF-8";
				$http.post('dedup/commit.do', g).success(function(res) {
	            	if(res) {
	            		$scope.showNotification('Commit done');
	            		$scope.search();
	            		$scope.hideSpinner();
	            	} else {
	                	$scope.hideSpinner();
	            		$scope.showError('Commit failed');
	            	}
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Commit failed: ' + err.message);
				});
				$scope.doResetForm();
			}
		}

		$scope.removeFromResultList = function(ids, results) {
			var tmp = [];	
			angular.forEach(results, function(r) {
		    	if(jQuery.grep(ids, function(val, i) {
		    		  return val == r.id;
				}).length == 0) {
		    		tmp.push(r);
		    	};
		    });		    
		    return tmp;			
		}
		
		$scope.removeFromIdList = function(ids, list) {
			var tmp = [];	
			angular.forEach(list, function(id) {
		    	if(jQuery.grep(ids, function(val, i) {
		    		  return val == id;
				}).length == 0) {
		    		tmp.push(id);
		    	};
		    });		    
		    return tmp;			
		}			
		
		$scope.add = function(id, idList) {
			var size = $scope.group.group.length;
			var ids = idList.split(",");
		    angular.forEach(ids, function(id) {
		    	if(jQuery.grep($scope.group.group, function(val, i) {
		    		  return val == id;
				}).length == 0) {
		        	$scope.group.group.push(id);
		        	$scope.searchById(id, $scope.group.entityType.type, $scope.defaultFields(), function(id, res) {
		        		if(!$scope.groupIdDetails.map[id]) {
		        			$scope.groupIdDetails.map[id] = res;
		        			$scope.groupIdDetails.list.push(res.results[0]);
		        		}
        			});
		    	};
		    });
    		angular.forEach(ids, function(mId) {
    			$scope.searchById(mId, $scope.group.entityType.type, $scope.defaultFields(), function(id, res) {
	        		if ($scope.group.details[id] == null) {
	        			$scope.group.details[id] = res;
	        			$scope.group.detailList.push(res.results[0]);
	        		}
    			});
    		});		    
        	$scope.searchById(id, $scope.group.entityType.type, $scope.defaultFields(), function(id, res) {
    			$scope.group.rootList.push(res.results[0]);
			});
		    if(ids && ids.length > 1) {
        		$scope.group.rootIds.push(id);
        		$scope.group.byRoot[id] = ids;
        		angular.forEach(ids, function(mId) {
        			$scope.group.byMerged[mId] = id;
        		});
		    }
		    var newSize = $scope.group.group.length - size;
		    if (newSize > 0) {
		    	$scope.showNotification('added ' + newSize + ' element(s)');
		    }
		}
		
		$scope.remove = function(objId, idList) {
			var tmpGroup = [];
			var ids = idList.split(",");
			var size = $scope.group.group.length;

		    $scope.group.group = $scope.removeFromIdList(ids, $scope.group.group);

		    angular.forEach(ids, function(id) {
		    	 delete $scope.group.details[id];
		    });
		    
		    $scope.group.rootList = $scope.removeFromResultList([objId], $scope.group.rootList)
		    $scope.group.detailList = $scope.removeFromResultList(ids, $scope.group.detailList)
		    
		    if ($scope.group.byMerged[objId]) {
		    	var x = $scope.removeFromIdList([objId], $scope.group.byRoot[objId]);
			    var y = $scope.group.byMerged[objId];
		    	
		    	$scope.group.byRoot[y] = x;
		    	
		    	delete $scope.group.byMerged[objId];
		    }
		    
		    if (ids.length > 1) {
		    	delete $scope.group.byRoot[objId];
		    	
				var tmp = [];		    
			    angular.forEach($scope.group.rootIds, function(id) {
			    	if(id != objId) {
			    		tmpRoots.push(id);
			    	};
			    });		    
			    $scope.group.rootIds = tmp;
		    }

	    	$scope.showNotification('removed ' + ids.length + ' element(s)');
		}
		
		$scope.removeAndDeassociate = function(id, idList, group) {
			$scope.remove(id, idList);
			
			var dissimilar = $scope.removeFromIdList([id], group);
			$scope.dissimilar.group[id] = dissimilar;
		}			
		
		$scope.contains = function(idCsv, list) {
			var res = true;
			if (idCsv && list) {
				angular.forEach(idCsv.split(","), function(id) {
					if(jQuery.grep(list, function(val, i) {
						  return val == id;
					}).length == 0) {
				    	res = false;
				    	return;
					};
				});
			} else {
				return false;
			}
			return res;
		}
		
		$scope.showRootModal = function(idCsv) {
			
			$scope.groupIdDetails.map = {};
			$scope.groupIdDetails.list = [];
			
			angular.forEach(idCsv.split(","), function(id) {
	        	$scope.searchById(id, $scope.group.entityType.type, $scope.allFields(), function(id, res) {
	        		//if(!$scope.groupIdDetails.map[id]) {
	        			$scope.groupIdDetails.map[id] = res;
	        			$scope.groupIdDetails.list.push(res.results[0]);
	        		//}
    			});
			});
			
			$('#showRootModal').modal('show');
		}
	}
]);

