package eu.dnetlib.msro.eagle.workflows.nodes.transform.tmid;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.FileSystemResource;

import eu.dnetlib.miscutils.functional.UnaryFunction;

public class TrismegistosInjectionUnaryFunction implements UnaryFunction<String, String> {
	private SAXReader reader;
	
	private static Map<String, List<String>> tmIdToLocalIdsMap;
	private static Map<String, String> localIdToTmIdMap;
	
	public TrismegistosInjectionUnaryFunction(String tmIdListPath) {
		this.reader = new SAXReader();
		tmIdToLocalIdsMap = new HashMap<String, List<String>>();
		localIdToTmIdMap = new HashMap<String, String>();
		
		FileSystemResource tmIds = new FileSystemResource(tmIdListPath);
		XMLInputFactory factory = XMLInputFactory.newInstance();
		try {
			XMLStreamReader reader = factory.createXMLStreamReader(tmIds.getInputStream());
			
			boolean isSafeToGetNextXmlElement = true;
			while (isSafeToGetNextXmlElement) {
				if (reader.getEventType() == XMLStreamConstants.START_ELEMENT) {
					if("tmid".equals(reader.getLocalName())){
				        parseTmEvent(reader);
				    }
				}
				
				if (reader.hasNext()) {
	                reader.next();
	            } else {
	                isSafeToGetNextXmlElement = false;
	                break;
	            }
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void parseTmEvent(XMLStreamReader reader) {
		String tmId = reader.getAttributeValue(null, "id");
		List<String> localIds = new ArrayList<String>();
		
		boolean isSafeToGetNextXmlElement = true;
		while(isSafeToGetNextXmlElement) {
			if (reader.getEventType() == XMLStreamConstants.END_ELEMENT) {
                break;
            } else {
            	if (reader.getEventType() == XMLStreamConstants.START_ELEMENT) {
            		if("link".equals(reader.getLocalName())){
				        String localId = parseLinkEvent(reader);
				        localIdToTmIdMap.put(localId, tmId);
				        localIds.add(localId);
				    }
            	}
            }
			
			try{
				if (reader.hasNext()) {
	                reader.next();
	            } else {
	                isSafeToGetNextXmlElement = false;
	                break;
	            }
			} catch (XMLStreamException e) {
				e.printStackTrace();
			}
		}
		tmIdToLocalIdsMap.put(tmId, localIds);
	}
	
	private String parseLinkEvent(XMLStreamReader reader) {
		String cp = reader.getAttributeValue(null, "cp");
		String val = "";
		boolean isSafeToGetNextXmlElement = true;
        while(isSafeToGetNextXmlElement) {
            if (reader.getEventType() == XMLStreamConstants.END_ELEMENT) {
                break;
            } else if (reader.getEventType() == XMLStreamConstants.CHARACTERS) {
                val = reader.getText();
            }
            
            try{
				if (reader.hasNext()) {
	                reader.next();
	            } else {
	                isSafeToGetNextXmlElement = false;
	                break;
	            }
			} catch (XMLStreamException e) {
				e.printStackTrace();
			}
        }
        return (cp + "::" + val);
	}
	
	@Override
	public String evaluate(String input) {
		try {
			Document doc = reader.read(new StringReader(input));
			Node entityType = doc.selectSingleNode("//*[local-name()='entityType']");
			
			// TMid injection on Artifacts/Inscriptions
			if ("artifact".equals(entityType.getText())) {
				Node recordSourceInfo = doc.selectSingleNode("//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']");
				String localIdKey = (recordSourceInfo.selectSingleNode("@providerAcronym")).getText() + "::" + (recordSourceInfo.selectSingleNode("./text()")).getText();
				String tmId = localIdToTmIdMap.get(localIdKey);
				if (tmId != null) {
					// TMid found! Prepare for injection..
					List<String> alternateIds = tmIdToLocalIdsMap.get(tmId);
					Element inscription = (Element) doc.selectSingleNode("//*[local-name()='inscription']");
					Element injectedHasTmId = prepareInjectedElement(tmId, alternateIds);
					replaceElement(inscription, (Element) inscription.selectSingleNode("hasTmId"), injectedHasTmId);
					return doc.asXML();
				} else {
					// There is no TM ID for this localID. Just return the input string here..
					return input;
				}
			}
			
			// TMid injection on other items with rel to Artifacts
			if ("visual".equals(entityType.getText()) || "documental".equals(entityType.getText())) {
				Node recordSourceInfo = doc.selectSingleNode("//*[local-name()='hasArtifact']/*[local-name()='recordSourceInfo']");
				String localIdKey = (recordSourceInfo.selectSingleNode("@providerAcronym")).getText() + "::" + (recordSourceInfo.selectSingleNode("./text()")).getText();
				String tmId = localIdToTmIdMap.get(localIdKey);
				if (tmId != null) {
					// TMid found! Prepare for injection..
					List<String> alternateIds = tmIdToLocalIdsMap.get(tmId);
					Element inscription = (Element) doc.selectSingleNode("//*[local-name()='hasArtifact']");
					Element injectedHasTmId = prepareInjectedElement(tmId, alternateIds);
					replaceElement(inscription, (Element) inscription.selectSingleNode("hasTmId"), injectedHasTmId);
					return doc.asXML();
				} else {
					// There is no TM ID for this localID. Just return the input string here..
					return input;
				}
			}
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return input;
	}

	private Element prepareInjectedElement(String tmId, List<String> alternateIds) {
		Document document = DocumentHelper.createDocument();
		Element hasTmId = document.addElement( "hasTmId" );
		hasTmId.addElement("tmId").addText(tmId);
		for (String alternateId : alternateIds) {
			String[] tokens = alternateId.split("::");
			hasTmId.addElement("alternateId").addAttribute("providerAcronym", tokens[0]).addAttribute("localId", tokens[1]);
		}
		return (Element) document.selectSingleNode("hasTmId");
	}
	
	private void replaceElement(Element parent, Element oldElement, Element newElement) {
		List parentContent = parent.content();
		int index = parentContent.indexOf(oldElement);
		parentContent.set(index, newElement);
	}

}
