/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.eagle.workflows.nodes.transform.tmid;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.FileSystemResource;

public class TrismegistosInjectionUnaryFunction
implements UnaryFunction<String, String> {
    private SAXReader reader = new SAXReader();
    private static Map<String, List<String>> tmIdToLocalIdsMap;
    private static Map<String, String> localIdToTmIdMap;

    public TrismegistosInjectionUnaryFunction(String tmIdListPath) {
        tmIdToLocalIdsMap = new HashMap<String, List<String>>();
        localIdToTmIdMap = new HashMap<String, String>();
        FileSystemResource tmIds = new FileSystemResource(tmIdListPath);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(tmIds.getInputStream());
            boolean isSafeToGetNextXmlElement = true;
            while (isSafeToGetNextXmlElement) {
                if (reader.getEventType() == 1 && "tmid".equals(reader.getLocalName())) {
                    this.parseTmEvent(reader);
                }
                if (reader.hasNext()) {
                    reader.next();
                    continue;
                }
                isSafeToGetNextXmlElement = false;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void parseTmEvent(XMLStreamReader reader) {
        String tmId = reader.getAttributeValue(null, "id");
        ArrayList<String> localIds = new ArrayList<String>();
        boolean isSafeToGetNextXmlElement = true;
        while (isSafeToGetNextXmlElement && reader.getEventType() != 2) {
            if (reader.getEventType() == 1 && "link".equals(reader.getLocalName())) {
                String localId = this.parseLinkEvent(reader);
                localIdToTmIdMap.put(localId, tmId);
                localIds.add(localId);
            }
            try {
                if (reader.hasNext()) {
                    reader.next();
                    continue;
                }
                isSafeToGetNextXmlElement = false;
                break;
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        tmIdToLocalIdsMap.put(tmId, localIds);
    }

    private String parseLinkEvent(XMLStreamReader reader) {
        String cp = reader.getAttributeValue(null, "cp");
        String val = "";
        boolean isSafeToGetNextXmlElement = true;
        while (isSafeToGetNextXmlElement && reader.getEventType() != 2) {
            if (reader.getEventType() == 4) {
                val = reader.getText();
            }
            try {
                if (reader.hasNext()) {
                    reader.next();
                    continue;
                }
                isSafeToGetNextXmlElement = false;
                break;
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        return cp + "::" + val;
    }

    public String evaluate(String input) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(input));
            Node entityType = doc.selectSingleNode("//*[local-name()='entityType']");
            if ("artifact".equals(entityType.getText())) {
                Node recordSourceInfo = doc.selectSingleNode("//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']");
                String localIdKey = recordSourceInfo.selectSingleNode("@providerAcronym").getText() + "::" + recordSourceInfo.selectSingleNode("./text()").getText();
                String tmId = localIdToTmIdMap.get(localIdKey);
                if (tmId != null) {
                    List<String> alternateIds = tmIdToLocalIdsMap.get(tmId);
                    Element inscription = (Element)doc.selectSingleNode("//*[local-name()='inscription']");
                    Element injectedHasTmId = this.prepareInjectedElement(tmId, alternateIds);
                    this.replaceElement(inscription, (Element)inscription.selectSingleNode("hasTmId"), injectedHasTmId);
                    return doc.asXML();
                }
                return input;
            }
            if ("visual".equals(entityType.getText()) || "documental".equals(entityType.getText())) {
                Node recordSourceInfo = doc.selectSingleNode("//*[local-name()='hasArtifact']/*[local-name()='recordSourceInfo']");
                String localIdKey = recordSourceInfo.selectSingleNode("@providerAcronym").getText() + "::" + recordSourceInfo.selectSingleNode("./text()").getText();
                String tmId = localIdToTmIdMap.get(localIdKey);
                if (tmId != null) {
                    List<String> alternateIds = tmIdToLocalIdsMap.get(tmId);
                    Element inscription = (Element)doc.selectSingleNode("//*[local-name()='hasArtifact']");
                    Element injectedHasTmId = this.prepareInjectedElement(tmId, alternateIds);
                    this.replaceElement(inscription, (Element)inscription.selectSingleNode("hasTmId"), injectedHasTmId);
                    return doc.asXML();
                }
                return input;
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return input;
    }

    private Element prepareInjectedElement(String tmId, List<String> alternateIds) {
        Document document = DocumentHelper.createDocument();
        Element hasTmId = document.addElement("hasTmId");
        hasTmId.addElement("tmId").addText(tmId);
        for (String alternateId : alternateIds) {
            String[] tokens = alternateId.split("::");
            hasTmId.addElement("alternateId").addAttribute("providerAcronym", tokens[0]).addAttribute("localId", tokens[1]);
        }
        return (Element)document.selectSingleNode("hasTmId");
    }

    private void replaceElement(Element parent, Element oldElement, Element newElement) {
        List parentContent = parent.content();
        int index = parentContent.indexOf(oldElement);
        parentContent.set(index, newElement);
    }
}

