/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.mediawiki;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.mediawiki.MediawikiIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;
import java.util.List;

public class MediawikiCollectorPlugin
implements CollectorPlugin {
    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        final String apnamespace = (String)interfaceDescriptor.getParams().get("apnamespace");
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (apnamespace == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'apnamespace' is null or empty");
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new MediawikiIterator(baseUrl, apnamespace);
            }
        };
    }

    public String getProtocol() {
        return "mediawiki";
    }

    public List<String> listNameParameters() {
        return Lists.newArrayList((Object[])new String[]{"apnamespace"});
    }
}

