/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.action.SubmitMapreduceJobAction;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.mapred.MapreduceJobMonitor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.utils.JobProfile;
import eu.dnetlib.data.hadoop.utils.ScanProperties;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class SubmitAdminJobAction
extends SubmitMapreduceJobAction {
    private static final Log log = LogFactory.getLog(SubmitAdminJobAction.class);

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob bbJob) {
        String jobName = (String)bbJob.getParameters().get("job.name");
        ClusterName clusterName = ClusterName.valueOf((String)((String)bbJob.getParameters().get("cluster")));
        try {
            JobProfile jobProfile = this.loadISJobConfiguration(jobName, bbJob.getParameters());
            this.validateJobParams(handler, bbJob, jobName, jobProfile);
            JobConf jobConf = this.prepareJob(this.getConf(clusterName), jobName, jobProfile, bbJob.getParameters());
            if (!this.clientMap.isMapreduceAvailable(clusterName)) {
                throw new HadoopServiceException("mapreduce not available for cluster: " + clusterName.toString());
            }
            this.logJobDetails(jobConf);
            RunningJob runningJob = this.clientMap.getJtClient(clusterName).submitJob(jobConf);
            String jobId = this.newJobId(clusterName, runningJob.getID().getId());
            this.jobRegistry.registerJob(HadoopJob.newInstance(jobId, clusterName, jobProfile, new MapreduceJobMonitor(runningJob, this.newCompletionCallback(handler, bbJob, jobId))));
            this.updateJobStatus(jobName);
            handler.ongoing(bbJob);
        }
        catch (Throwable e) {
            log.error((Object)("error executing hadoop job: " + jobName), e);
            handler.failed(bbJob, e);
        }
    }

    @Override
    protected JobConf prepareJob(Configuration configuration, String jobName, JobProfile jobProfile, Map<String, String> parameters) throws IOException, HadoopServiceException {
        log.info((Object)("creating job: " + jobName));
        JobConf jobConf = new JobConf(configuration);
        jobConf.setJobName(jobName);
        jobConf.set("dnet.mapred.job.description", jobProfile.getDescription());
        String jobLib = this.getJobLib(configuration, jobProfile);
        jobConf.setJar(new Path(jobLib).toString());
        this.set(jobConf, jobProfile.getJobDefinition());
        this.set(jobConf, parameters);
        if (jobName.equals("copytable")) {
            return this.copyTable(jobProfile, parameters, jobConf);
        }
        throw new HadoopServiceException("unknown admin job: " + jobName);
    }

    private JobConf copyTable(JobProfile jobProfile, Map<String, String> parameters, JobConf jobConf) throws IOException {
        ScanProperties scan = jobProfile.getScanProperties();
        ArrayList params = Lists.newArrayList();
        if (!scan.getFamilies().isEmpty()) {
            params.add("--families=" + Joiner.on((String)",").join(scan.getFamilies()));
        }
        if (parameters.containsKey("hbase.mapred.output.quorum")) {
            params.add("--peer.addr=" + parameters.get("hbase.mapred.output.quorum"));
        }
        params.add(parameters.get("hbase.mapreduce.outputtable"));
        Configuration copyConf = CopyTable.createSubmittableJob((Configuration)jobConf, (String[])((String[])Iterables.toArray((Iterable)params, String.class))).getConfiguration();
        return this.merge(jobConf, copyConf);
    }

    private JobConf merge(JobConf jobConf, Configuration copyConf) {
        for (Map.Entry e : copyConf) {
            jobConf.set((String)e.getKey(), (String)e.getValue());
        }
        return jobConf;
    }
}

