/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.action.AbstractHadoopAction;
import eu.dnetlib.data.hadoop.action.ImportEprActionCallback;
import eu.dnetlib.data.hadoop.action.SequenceFileFeeder;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ImportEprHdfsAction
extends AbstractHadoopAction {
    private static final Log log = LogFactory.getLog(ImportEprHdfsAction.class);
    private SequenceFileFeeder sequenceFileFeeder;

    @Override
    public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) {
        try {
            String epr = DnetXsltFunctions.decodeBase64((String)((String)job.getParameters().get("input_epr")));
            ClusterName clusterName = ClusterName.valueOf((String)((String)job.getParameters().get("cluster")));
            String path = (String)job.getParameters().get("path");
            log.info((Object)("Starting import in hdfs sequence file: " + path));
            handler.ongoing(job);
            this.getSequenceFileFeeder().feed(epr, clusterName, path, new ImportEprActionCallback(){

                @Override
                public void done(int count) {
                    log.info((Object)"Import completed successfully");
                    job.getParameters().put("count", String.valueOf(count));
                    handler.done(job);
                }

                @Override
                public void failed(Throwable e) {
                    log.error((Object)"Import failed", e);
                    handler.failed(job, e);
                }
            });
        }
        catch (Throwable e) {
            log.error((Object)"Import failed", e);
            handler.failed(job, e);
        }
    }

    public SequenceFileFeeder getSequenceFileFeeder() {
        return this.sequenceFileFeeder;
    }

    @Required
    public void setSequenceFileFeeder(SequenceFileFeeder sequenceFileFeeder) {
        this.sequenceFileFeeder = sequenceFileFeeder;
    }
}

