/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.hadoop.HadoopClientMap;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.utils.HadoopUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Autowired;

public class HadoopServiceCore {
    private static final Log log = LogFactory.getLog(HadoopServiceCore.class);
    @Autowired
    private HadoopClientMap clients;
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;

    public List<String> listTables(ClusterName clusterName) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])admin.listTables()), HadoopUtils.tableName()));
    }

    private HBaseAdmin getHBaseAdmin(ClusterName clusterName) throws HadoopServiceException {
        HBaseAdmin admin = this.clients.getHbaseAdmin(clusterName);
        if (admin == null) {
            throw new HadoopServiceException(String.format("HBase admin not available for cluster: '%s'", clusterName.toString()));
        }
        return admin;
    }

    public void truncateTable(ClusterName clusterName, String table) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (!admin.tableExists(table)) {
            throw new IllegalStateException("cannot truncate unexisting table");
        }
        HTableDescriptor desc = admin.getTableDescriptor(table.getBytes());
        log.info((Object)("disabling table: " + table));
        admin.disableTable(table);
        log.info((Object)("deleting table: " + table));
        admin.deleteTable(table);
        log.info((Object)("creating table: " + table));
        admin.createTable(desc);
    }

    public boolean existTable(ClusterName clusterName, String table) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        return admin.tableExists(table);
    }

    public void dropTable(ClusterName clusterName, String table) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (!admin.tableExists(table)) {
            throw new IllegalStateException("cannot drop unexisting table: '" + table + "'");
        }
        log.info((Object)("disabling table: " + table));
        admin.disableTable(table);
        log.info((Object)("deleting table: " + table));
        admin.deleteTable(table);
    }

    public void createTable(ClusterName clusterName, String table, Set<String> columns) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (admin.tableExists(table)) {
            throw new IllegalStateException("table already exists");
        }
        HTableDescriptor desc = new HTableDescriptor(table);
        for (String column : columns) {
            HColumnDescriptor hds = new HColumnDescriptor(column);
            hds.setMaxVersions(1);
            desc.addFamily(hds);
        }
        log.info((Object)("creating hbase table: " + table));
        admin.createTable(desc);
        log.info((Object)("created hbase table: [" + table + "] descriptor: [" + desc.toString() + "]"));
    }

    public void ensureTable(ClusterName clusterName, String table, Set<String> columns) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (!admin.tableExists(table)) {
            this.createTable(clusterName, table, columns);
        } else {
            HTableDescriptor desc = admin.getTableDescriptor(Bytes.toBytes((String)table));
            HashSet foundColumns = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])desc.getColumnFamilies()), HadoopUtils.columnName()));
            log.info((Object)("ensuring columns on table " + table + ": " + columns));
            ArrayList missingColumns = Lists.newArrayList((Iterable)Iterables.filter(columns, HadoopUtils.columnPredicate(foundColumns)));
            if (!missingColumns.isEmpty()) {
                if (admin.isTableEnabled(table)) {
                    admin.disableTable(table);
                }
                for (String column : missingColumns) {
                    log.info((Object)("hbase table: '" + table + "', adding column: " + column));
                    admin.addColumn(table, new HColumnDescriptor(column));
                }
                admin.enableTable(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ClusterName clusterName, String tableName, List<Put> puts) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        HTable table = new HTable(conf, tableName);
        try {
            table.put(puts);
        }
        finally {
            table.flushCommits();
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ClusterName clusterName, String tableName, List<Delete> deletes) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        HTable table = new HTable(conf, tableName);
        try {
            table.delete(deletes);
        }
        finally {
            table.flushCommits();
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getRow(ClusterName clusterName, String tableName, byte[] id) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        try (HTable table = new HTable(conf, tableName);){
            Result result = table.get(new Get(id));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Result> getRows(ClusterName clusterName, String tableName, Scan scan) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        try (HTable table = new HTable(conf, tableName);){
            ArrayList arrayList;
            ResultScanner rs = table.getScanner(scan);
            try {
                arrayList = Lists.newArrayList((Iterator)rs.iterator());
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return arrayList;
        }
    }

    public Configuration getClusterConiguration(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }
}

