package eu.dnetlib.data.hadoop.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;

public class ImportEprHbaseAction extends AbstractHadoopAction {

	private static final Log log = LogFactory.getLog(ImportEprHbaseAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	private HbaseTableFeeder hbaseTableFeeder;

	@Override
	public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) {
		try {

			final String epr = DnetXsltFunctions.decodeBase64(job.getParameters().get("input_epr"));
			final String xsl = DnetXsltFunctions.decodeBase64(job.getParameters().get("xslt"));
			final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
			final String table = job.getParameters().get("table");

			log.info("Starting import in table " + table);

			handler.ongoing(job);
			hbaseTableFeeder.feed(epr, xsl, clusterName, table, new ImportEprActionCallback() {

				@Override
				public void done(int count) {
					log.info("Import completed successfully");
					job.getParameters().put("count", String.valueOf(count));
					handler.done(job);
				}

				@Override
				public void failed(final Throwable e) {
					log.error("Import failed", e);
					handler.failed(job, e);
				}
			});
		} catch (Throwable e) {
			log.error("Import failed", e);
			handler.failed(job, e);
		}
	}

	public HbaseTableFeeder getHbaseTableFeeder() {
		return hbaseTableFeeder;
	}

	@Required
	public void setHbaseTableFeeder(final HbaseTableFeeder hbaseTableFeeder) {
		this.hbaseTableFeeder = hbaseTableFeeder;
	}

}
