/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hbase;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.springframework.beans.factory.annotation.Autowired;

public class HBaseAdminFactory {
    private static final Log log = LogFactory.getLog(HBaseAdminFactory.class);
    @Autowired
    private ConfigurationEnumerator configurationEnumerator;

    public HBaseAdmin newInstance(ClusterName clusterName) throws HadoopServiceException {
        try {
            log.info((Object)("init hbaseAdmin, cluster: " + clusterName.toString()));
            return new HBaseAdmin(this.configurationEnumerator.get(clusterName));
        }
        catch (MasterNotRunningException e) {
            throw new HadoopServiceException((Throwable)e);
        }
        catch (ZooKeeperConnectionException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }
}

