/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.mapred;

import com.google.common.collect.Maps;
import eu.dnetlib.data.hadoop.action.JobCompletion;
import eu.dnetlib.data.hadoop.action.JobMonitor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;

public class MapreduceJobMonitor
extends JobMonitor {
    private static final Log log = LogFactory.getLog(MapreduceJobMonitor.class);
    private final int monitorSleepTimeSecs = 10;
    private final RunningJob runningJob;

    public MapreduceJobMonitor(RunningJob runningJob, JobCompletion callback) {
        super(callback);
        this.runningJob = runningJob;
    }

    @Override
    public void run() {
        try {
            log.info((Object)("waiting for job completion: " + this.getRunningJob().getID().getId()));
            int runState = this.getRunState();
            while (!this.getRunningJob().isComplete()) {
                Thread.sleep(10000L);
                int currentState = this.getRunState();
                if (currentState == runState) continue;
                runState = currentState;
                this.lastActivity = new Date(System.currentTimeMillis());
            }
            if (this.getRunningJob().isSuccessful()) {
                log.info((Object)("job successful: " + this.getRunningJob().getID().getId()));
                this.getCallback().done(this.asMap(this.getRunningJob().getCounters()));
            } else {
                String msg = "hadoop job: " + this.getHadoopId() + " failed with status: " + this.getStatus();
                this.getCallback().failed(msg, new HadoopServiceException(msg));
            }
        }
        catch (Throwable e) {
            this.getCallback().failed(this.getHadoopId(), e);
        }
    }

    @Override
    public String getHadoopId() {
        return String.valueOf(this.getRunningJob().getID().getId());
    }

    protected Map<String, String> asMap(Counters counters) {
        HashMap res = Maps.newHashMap();
        if (counters != null) {
            for (Counters.Group group : counters) {
                for (Counters.Counter counter : group) {
                    res.put(group.getDisplayName() + "." + counter.getDisplayName(), String.valueOf(counter.getValue()));
                }
            }
        }
        return res;
    }

    public RunningJob getRunningJob() {
        return this.runningJob;
    }

    @Override
    public String getStatus() {
        try {
            return JobStatus.getJobRunState((int)this.getRunState());
        }
        catch (IOException e) {
            log.error((Object)"error accessing job status", (Throwable)e);
            return "UNKNOWN";
        }
    }

    private int getRunState() throws IOException {
        return this.getRunningJob().getJobStatus().getRunState();
    }

    @Override
    public Date getLastActivity() {
        return this.lastActivity;
    }

    @Override
    public Date getStartTime() throws HadoopServiceException {
        try {
            return new Date(this.getRunningJob().getJobStatus().getStartTime());
        }
        catch (IOException e) {
            throw new HadoopServiceException("unable to read job start time", (Throwable)e);
        }
    }

    @Override
    public String getTrackerUrl() {
        return this.getRunningJob().getTrackingURL();
    }

    @Override
    public void kill() {
        try {
            log.info((Object)("killing job: " + this.getHadoopId()));
            this.getRunningJob().killJob();
        }
        catch (IOException e) {
            log.error((Object)("unable to kill job: " + this.getHadoopId()), (Throwable)e);
        }
    }
}

