/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopJobDescriptor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;

public class HadoopUtils {
    public static Function<HTableDescriptor, String> tableName() {
        return new Function<HTableDescriptor, String>(){

            public String apply(HTableDescriptor d) {
                return d.getNameAsString();
            }
        };
    }

    public static Function<HColumnDescriptor, String> columnName() {
        return new Function<HColumnDescriptor, String>(){

            public String apply(HColumnDescriptor d) {
                return d.getNameAsString();
            }
        };
    }

    public static Predicate<String> columnPredicate(Set<String> cols) {
        return new HadoopUtils().getSetPredicate(cols);
    }

    public SetPredicate getSetPredicate(Set<String> set) {
        return new SetPredicate(set);
    }

    public static Function<Map.Entry<String, HadoopJob>, HadoopJobDescriptor> hadoopJobDescriptor() {
        return new Function<Map.Entry<String, HadoopJob>, HadoopJobDescriptor>(){

            public HadoopJobDescriptor apply(Map.Entry<String, HadoopJob> e) {
                try {
                    return e.getValue().asDescriptor();
                }
                catch (HadoopServiceException e1) {
                    return null;
                }
            }
        };
    }

    public static Predicate<HadoopJob> filterByCluster(final ClusterName clusterName) {
        return new Predicate<HadoopJob>(){

            public boolean apply(HadoopJob job) {
                return job.getClusterName().equals((Object)clusterName);
            }
        };
    }

    class SetPredicate
    implements Predicate<String> {
        private final Set<String> set;

        public SetPredicate(Set<String> set) {
            this.set = set;
        }

        public boolean apply(String s) {
            return !this.set.contains(s);
        }
    }
}

