/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.data.hadoop.HadoopClients;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.hbase.HBaseAdminFactory;
import eu.dnetlib.data.hadoop.oozie.OozieClientFactory;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.mapreduce.JobClientFactory;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.mapred.JobClient;
import org.apache.oozie.client.OozieClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Lazy;

public class HadoopClientMap {
    private static final Log log = LogFactory.getLog(HadoopClientMap.class);
    @Lazy
    @Autowired
    private JobClientFactory jobClientFactory;
    @Lazy
    @Autowired
    private OozieClientFactory oozieClientFactory;
    @Lazy
    @Autowired
    private HBaseAdminFactory hbaseAdminFactory;
    private Map<String, Map<String, String>> enabledClients = Maps.newHashMap();
    private final Map<ClusterName, HadoopClients> clients = Maps.newHashMap();
    private final Executor executor = Executors.newSingleThreadExecutor();

    public void init() throws HadoopServiceException {
        log.info((Object)("clients conf: " + this.getEnabledClients()));
        for (final String name : this.enabledClients.keySet()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.info((Object)("initializing clients for hadoop cluster: " + name));
                        ClusterName clusterName = ClusterName.valueOf((String)name);
                        Map clientsConf = (Map)HadoopClientMap.this.enabledClients.get(name);
                        JobClient jobClient = Boolean.valueOf((String)clientsConf.get("mapred")) != false ? HadoopClientMap.this.jobClientFactory.newInstance(name) : null;
                        OozieClient oozieClient = Boolean.valueOf((String)clientsConf.get("oozie")) != false ? HadoopClientMap.this.oozieClientFactory.newInstance(clusterName) : null;
                        HBaseAdmin hbaseAdmin = Boolean.valueOf((String)clientsConf.get("hbase")) != false ? HadoopClientMap.this.hbaseAdminFactory.newInstance(clusterName) : null;
                        HadoopClientMap.this.clients.put(clusterName, new HadoopClients(jobClient, oozieClient, hbaseAdmin));
                    }
                    catch (Exception e) {
                        log.error((Object)("Error initializing hadoop client for cluster: " + name), (Throwable)e);
                    }
                }
            });
        }
    }

    public JobClient getJtClient(ClusterName name) {
        return this.getClients(name).getJtClient();
    }

    public boolean isMapreduceAvailable(ClusterName name) {
        return this.getClients(name).isMapredAvailable();
    }

    public OozieClient getOozieClient(ClusterName name) {
        return this.getClients(name).getOozieClient();
    }

    public boolean isOozieAvailable(ClusterName name) {
        return this.getClients(name).isOozieAvailable();
    }

    public HBaseAdmin getHbaseAdmin(ClusterName name) {
        return this.getClients(name).getHbaseAdmin();
    }

    public HadoopClients getClients(ClusterName name) {
        HadoopClients hadoopClients = this.clients.get(name);
        if (hadoopClients == null) {
            throw new IllegalArgumentException("cluster " + name.toString() + " is currently disabled");
        }
        return hadoopClients;
    }

    public String getEnabledClients() {
        return new Gson().toJson(this.enabledClients);
    }

    @Required
    public void setEnabledClients(String enabledClients) {
        this.enabledClients = (Map)new Gson().fromJson(enabledClients, Map.class);
    }
}

