package eu.dnetlib.data.hadoop.utils;

import java.util.Set;

import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FilterList.Operator;

import com.google.common.collect.Sets;

public class ScanProperties {

	private static final Operator DEFAULT_OPERATOR = Operator.MUST_PASS_ALL;

	private int caching = 100;
	private FilterList filterList;
	private Set<String> families = Sets.newHashSet();

	public ScanProperties(final String op) {
		Operator operator = DEFAULT_OPERATOR;
		if ((op != null) && !op.isEmpty()) {
			operator = Operator.valueOf(op);
		}
		filterList = new FilterList(operator);
	}

	public FilterList getFilterList() {
		return filterList;
	}

	public void setFilterList(final FilterList filterList) {
		this.filterList = filterList;
	}

	public Set<String> getFamilies() {
		return families;
	}

	public void setFamilies(final Set<String> families) {
		this.families = families;
	}

	public int getCaching() {
		return caching;
	}

	public void setCaching(int caching) {
		this.caching = caching;
	}
}
