/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.oozie;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.client.OozieClient;
import org.springframework.beans.factory.annotation.Autowired;

public class OozieClientFactory {
    private static final String ENV_ATTRIBUTE_OOZIE_SERVICE_LOC = "oozie.service.loc";
    private static final Log log = LogFactory.getLog(OozieClientFactory.class);
    @Autowired
    private ConfigurationEnumerator configurationEnumerator;

    public OozieClient newInstance(ClusterName clusterName) {
        String oozieServiceLocation = this.configurationEnumerator.get(clusterName).get(ENV_ATTRIBUTE_OOZIE_SERVICE_LOC);
        log.info((Object)("init oozie client, cluster: " + clusterName.toString() + ", oozie server: " + oozieServiceLocation));
        try {
            return new OozieClient(oozieServiceLocation);
        }
        catch (Throwable e) {
            log.warn((Object)("unable to initialize oozie client for cluster: " + clusterName.toString()));
            return null;
        }
    }
}

