/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.action.ImportEprActionCallback;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.hdfs.SequenceFileWriterFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SequenceFileFeeder {
    private static final Log log = LogFactory.getLog(SequenceFileFeeder.class);
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;
    @Autowired
    protected SequenceFileWriterFactory sequenceFileWriterFactory;

    public void feed(final String epr, final ClusterName clusterName, final String path, final ImportEprActionCallback callback) {
        Thread feederThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.done(this.doWrite(epr, clusterName, path));
                }
                catch (Throwable e) {
                    callback.failed(e);
                }
            }

            private int doWrite(String epr2, ClusterName clusterName2, String path2) throws IOException {
                SequenceFile.Writer writer = SequenceFileFeeder.this.sequenceFileWriterFactory.getSequenceFileWriter(Text.class, Text.class, SequenceFileFeeder.this.getConf(clusterName2), new Path(path2));
                Text idText = new Text();
                Text bodyText = new Text();
                int count = 0;
                for (String record : SequenceFileFeeder.this.getResultSetClientFactory().getClient(epr2)) {
                    idText.set(String.valueOf(count++));
                    bodyText.set(record);
                    writer.append((Writable)idText, (Writable)bodyText);
                }
                writer.close();
                log.info((Object)("written " + count + " records in sequence file: " + path2));
                return count;
            }
        });
        feederThread.start();
    }

    protected Configuration getConf(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

