package eu.dnetlib.functionality.index.feed;

import java.util.Map;

import com.google.common.base.Function;

import eu.dnetlib.functionality.index.model.Any.ValueType;
import eu.dnetlib.functionality.index.model.document.IndexDocument;
import eu.dnetlib.functionality.index.utils.MetadataReference;

/**
 * A factory for creating DocumentMapper objects.
 */
public interface DocumentMapperFactory {

	/**
	 * Gets the record mapper.
	 * 
	 * @param schema
	 *            the schema
	 * @param mdRef
	 *            the md ref
	 * @param dsId
	 *            the ds id
	 * @param version
	 *            the version
	 * @return the record mapper
	 */
	public Function<String, IndexDocument> getRecordMapper(final Map<String, ValueType> schema,
			final MetadataReference mdRef,
			final String dsId,
			final String version);

}
