/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mycila.xmltool.CallBack;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import eu.dnetlib.functionality.index.utils.MetadataReferenceFactory;
import eu.dnetlib.functionality.index.utils.ServiceTools;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class MDFormatReader {
    @Autowired
    private ServiceTools serviceTools;
    @Autowired
    private MetadataReferenceFactory mdFactory;

    public List<MetadataReference> listMDRefs() throws IndexClientException {
        return this.serviceTools.listMDRefs();
    }

    public Document getFields(MetadataReference mdRef) {
        String fields = this.serviceTools.getIndexFields(mdRef);
        return fields != null && !fields.isEmpty() ? XmlUtils.parse(fields) : null;
    }

    public Map<String, String> getAttributeMap(MetadataReference mdRef, String attribute) throws IndexClientException {
        return this.getAttributeTable(mdRef, attribute).column((Object)attribute);
    }

    public Table<String, String, String> getAttributeTable(MetadataReference mdRef, final String ... attributeList) throws IndexClientException {
        String fields = this.serviceTools.getIndexFields(mdRef);
        if (fields.isEmpty()) {
            throw new IndexClientException("No result getting index layout informations");
        }
        HashBasedTable t = HashBasedTable.create();
        XMLDoc.from((String)this.serviceTools.getIndexFields(mdRef), (boolean)false).forEach("//FIELD", new CallBack((Table)t){
            final /* synthetic */ Table val$t;
            {
                this.val$t = table;
            }

            public void execute(XMLTag field) {
                for (String attribute : attributeList) {
                    String value = null;
                    if ("xpath".equals(attribute)) {
                        if (!field.hasAttribute("xpath") && !field.hasAttribute("value")) {
                            return;
                        }
                        String string = value = field.hasAttribute("xpath") ? field.getAttribute("xpath") : field.getAttribute("value");
                    }
                    if ("weight".equals(attribute)) {
                        if (!field.hasAttribute(attribute)) {
                            return;
                        }
                        String string = value = field.hasAttribute(attribute) ? field.getAttribute(attribute) : "";
                    }
                    if (value == null) {
                        value = field.getAttribute(attribute);
                    }
                    this.val$t.put((Object)field.getAttribute("name").toLowerCase(), (Object)attribute, (Object)value);
                }
            }
        });
        return t;
    }

    static class XmlUtils {
        XmlUtils() {
        }

        public static Document parse(String xml) {
            try {
                return new SAXReader().read((Reader)new StringReader(xml));
            }
            catch (DocumentException e) {
                throw new IllegalArgumentException("cannot parse: " + xml);
            }
        }

        public static InputSource asInputSource(String input) throws DocumentException {
            return new InputSource(new StringReader(XmlUtils.parse(input).asXML()));
        }
    }
}

