package eu.dnetlib.functionality.index.client;

import java.util.Map;

import eu.dnetlib.functionality.index.cql.CqlValueTransformerMap;
import eu.dnetlib.functionality.index.query.IndexQueryFactory;
import eu.dnetlib.functionality.index.utils.MetadataReference;

public abstract class AbstractIndexClient implements IndexClient {

	protected static String INDEX_HOST = "host";
	protected static String INDEX_PORT = "port";
	protected static String INDEX_BACKEND_ID = "id";
	protected static String ZK_ADDRESS = "address";

	/** The format. */
	private String format;

	/** The layout. */
	private String layout;

	/** The interpretation. */
	private String interpretation;

	protected Map<String, String> serviceProperties;

	public AbstractIndexClient(final String format, final String layout, final String interpretation, final Map<String, String> serviceProperties) {
		this.format = format;
		this.layout = layout;
		this.interpretation = interpretation;
		this.serviceProperties = serviceProperties;
	}

	public abstract CqlValueTransformerMap getCqlValueTransformerMap(MetadataReference mdRef) throws IndexClientException;

	public abstract IndexQueryFactory getIndexQueryFactory();

	/**
	 * Gets the format.
	 *
	 * @return the format
	 */
	public String getFormat() {
		return format;
	}

	/**
	 * Sets the format.
	 *
	 * @param format
	 *            the format
	 */
	public void setFormat(final String format) {
		this.format = format;
	}

	/**
	 * Gets the layout.
	 *
	 * @return the layout
	 */
	public String getLayout() {
		return layout;
	}

	/**
	 * Sets the layout.
	 *
	 * @param layout
	 *            the layout
	 */
	public void setLayout(final String layout) {
		this.layout = layout;
	}

	/**
	 * Gets the interpretation.
	 *
	 * @return the interpretation
	 */
	public String getInterpretation() {
		return interpretation;
	}

	/**
	 * Sets the interpretation.
	 *
	 * @param interpretation
	 *            the interpretation
	 */
	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public Map<String, String> getServiceProperties() {
		return serviceProperties;
	}

	public void setServiceProperties(final Map<String, String> serviceProperties) {
		this.serviceProperties = serviceProperties;
	}

}
