/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.query;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.functionality.index.client.AbstractIndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.cql.CqlTranslator;
import eu.dnetlib.functionality.index.cql.TranslatedQuery;
import eu.dnetlib.functionality.index.query.BrowseAliases;
import eu.dnetlib.functionality.index.query.IndexQuery;
import eu.dnetlib.functionality.index.query.Pruner;
import eu.dnetlib.functionality.index.query.QueryLanguage;
import eu.dnetlib.functionality.index.query.Weights;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class IndexQueryFactory {
    private Pruner pruner;
    private Pruner cqlPruner;
    private Map<String, List<String>> defaultQueryParams;
    @Autowired
    private CqlTranslator translator;
    @Autowired
    private BrowseAliases browseAliases;
    @Autowired
    private Weights weights;

    protected abstract IndexQuery newInstance(TranslatedQuery var1, Pruner.Result var2, QueryLanguage var3);

    protected abstract IndexQuery setQueryOptions(IndexQuery var1, AbstractIndexClient var2);

    public IndexQuery getIndexQuery(QueryLanguage lang, String query, AbstractIndexClient client, MetadataReference mdRef) throws IndexClientException {
        String myquery = query;
        if (myquery == null || myquery.isEmpty()) {
            throw new IndexClientException("query cannot be empty or null");
        }
        try {
            Pruner.Result cqlRes = this.getCqlPruner().prune(this.getCqlPruner().parse(myquery));
            Pruner.Result res = this.getPruner().prune(cqlRes.getNode());
            TranslatedQuery tQuery = this.translator.getTranslatedQuery(res.getNode(), client.getCqlValueTransformerMap(mdRef), this.overrideCqlParams(cqlRes.getOptionMap()), this.browseAliases.get(mdRef), (Map)this.weights.get(mdRef));
            return this.setQueryOptions(this.newInstance(tQuery, res, lang), client);
        }
        catch (Exception e) {
            throw new IndexClientException(e);
        }
    }

    private Map<String, List<String>> overrideCqlParams(Map<String, List<String>> override) {
        HashMap cqlParams = Maps.newHashMap();
        cqlParams.putAll(this.getDefaultQueryParams());
        cqlParams.putAll(override);
        return cqlParams;
    }

    public List<String> getBrowsableFields(List<String> fields, MetadataReference mdRef) throws IndexClientException {
        return this.getBrowsableFields(fields, this.browseAliases.get(mdRef));
    }

    public List<String> getBrowsableFields(List<String> fields, BiMap<String, String> aliases) {
        ArrayList browsables = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (String f : fields) {
            if (aliases.containsKey((Object)f)) {
                browsables.add(aliases.get((Object)f));
                continue;
            }
            browsables.add(f);
        }
        return browsables;
    }

    public Pruner getPruner() {
        return this.pruner;
    }

    public void setPruner(Pruner pruner) {
        this.pruner = pruner;
    }

    public Pruner getCqlPruner() {
        return this.cqlPruner;
    }

    public void setCqlPruner(Pruner cqlPruner) {
        this.cqlPruner = cqlPruner;
    }

    public Map<String, List<String>> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    public void setDefaultQueryParams(Map<String, List<String>> defaultQueryParams) {
        this.defaultQueryParams = defaultQueryParams;
    }
}

