package eu.dnetlib.data.mapreduce.hbase.oai;

import java.io.IOException;
import java.util.Properties;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;

public class OAIFeedJob extends AbstractHBaseMapReduceJob {

	@Override
	public Job setJobDetails(final Job job, final Properties p) {

		job.setInputFormatClass(SequenceFileInputFormat.class);
		try {
			FileInputFormat.setInputPaths(job, p.getProperty(JobParams.MAPRED_INPUT_DIR));
			FileOutputFormat.setOutputPath(job, new Path(p.getProperty(JobParams.MAPRED_OUTPUT_DIR)));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		job.setMapperClass(OaiFeedMapper.class);
		job.setMapOutputKeyClass(NullWritable.class);
		job.setMapOutputValueClass(NullWritable.class);

		job.setNumReduceTasks(0);

		job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
		job.getConfiguration().setBoolean("mapreduce.map.speculative", false);

		job.getConfiguration().setBoolean("mapred.compress.map.output", true);

		return job;
	}

}
