package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.io.IOException;

import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.pace.model.Person;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;

public class DedupPersonMapper extends TableMapper<Text, ImmutableBytesWritable> {

	private DedupConfig dedupConf;

	private Text rowKey;

	private ImmutableBytesWritable ibw;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		dedupConf = DedupConfigLoader.load(context.getConfiguration().get("dedup.wf.conf"));
		rowKey = new Text();
		ibw = new ImmutableBytesWritable();
	}

	@Override
	protected void map(final ImmutableBytesWritable keyIn, final Result result, final Context context) throws IOException, InterruptedException {
		// System.out.println("got key: " + new String(keyIn.copyBytes()));

		if (DedupUtils.isRoot(new String(keyIn.copyBytes()))) {
			context.getCounter(dedupConf.getEntityType(), "roots skipped").increment(1);
			return;
		}
		byte[] body = result.getValue(dedupConf.getEntityNameBytes(), DedupUtils.BODY_B);

		if (body != null) {
			try {
				OafDecoder decoder = OafDecoder.decode(body);

				String hash = new Person(decoder.getEntity().getPerson().getMetadata().getFullname().getValue(), false).hash();
				// String hash = new Person(getPersonName(decoder), true).hash();

				rowKey.set(hash);
				ibw.set(body);
				context.write(rowKey, ibw);

			} catch (Throwable e) {
				System.out.println("GOT EX " + e);
				e.printStackTrace(System.err);
				context.getCounter(dedupConf.getEntityType(), e.getClass().toString()).increment(1);
			}
		} else {
			context.getCounter(dedupConf.getEntityType(), "missing body").increment(1);
		}
	}

	// private String getPersonName(OafDecoder decoder) {
	// Metadata m = decoder.getEntity().getPerson().getMetadata();
	// String secondnames = Joiner.on(" ").join(m.getSecondnamesList());
	//
	// return isValid(m.getFullname()) ? m.getFullname() : (secondnames + ", " + m.getFirstname());
	// }

	// private boolean isValid(String fullname) {
	// return fullname != null && !fullname.isEmpty();
	// }

}
