/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.DedupSimilarityProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationOrganizationProtos;
import eu.dnetlib.data.proto.PersonPersonProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.util.DedupConfig;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class DedupUtils {
    public static final String CF_SEPARATOR = "_";
    public static final String ROOT = "dedup_wf";
    public static final String BODY_S = "body";
    public static final byte[] BODY_B = Bytes.toBytes((String)"body");

    public static String dedupPrefix(String dedupRun) {
        return "|dedup_wf_" + dedupRun + "::";
    }

    public static String newId(String id, String dedupRun) {
        if (dedupRun == null || dedupRun.length() != 3) {
            throw new IllegalArgumentException("wrong dedupRun param");
        }
        return id.replaceFirst("\\|.*\\:\\:", DedupUtils.dedupPrefix(dedupRun));
    }

    public static byte[] newIdBytes(String s, String dedupRun) {
        return DedupUtils.newId(s, dedupRun).getBytes();
    }

    public static byte[] newIdBytes(ByteBuffer b, String dedupRun) {
        return DedupUtils.newId(new String(b.array()), dedupRun).getBytes();
    }

    public static boolean isRoot(String s) {
        return s.contains(ROOT);
    }

    public static boolean isRoot(ImmutableBytesWritable s) {
        return DedupUtils.isRoot(s.copyBytes());
    }

    public static boolean isRoot(byte[] s) {
        return DedupUtils.isRoot(new String(s));
    }

    public static String getDedupCF_merges(TypeProtos.Type type) {
        return DedupUtils.getRelType(type) + CF_SEPARATOR + RelTypeProtos.SubRelType.dedup + CF_SEPARATOR + DedupProtos.Dedup.RelName.merges;
    }

    public static byte[] getDedupCF_mergesBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)DedupUtils.getDedupCF_merges(type));
    }

    public static String getDedupCF_mergedIn(TypeProtos.Type type) {
        return DedupUtils.getRelType(type) + CF_SEPARATOR + RelTypeProtos.SubRelType.dedup + CF_SEPARATOR + DedupProtos.Dedup.RelName.isMergedIn;
    }

    public static byte[] getDedupCF_mergedInBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)DedupUtils.getDedupCF_mergedIn(type));
    }

    public static String getSimilarityCF(TypeProtos.Type type) {
        return DedupUtils.getRelType(type) + CF_SEPARATOR + RelTypeProtos.SubRelType.dedupSimilarity + CF_SEPARATOR + DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo;
    }

    public static byte[] getSimilarityCFBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)DedupUtils.getSimilarityCF(type));
    }

    public static String getRelTypeString(TypeProtos.Type type) {
        return DedupUtils.getRelType(type).toString();
    }

    public static RelTypeProtos.RelType getRelType(TypeProtos.Type type) {
        switch (type) {
            case organization: {
                return RelTypeProtos.RelType.organizationOrganization;
            }
            case person: {
                return RelTypeProtos.RelType.personPerson;
            }
            case result: {
                return RelTypeProtos.RelType.resultResult;
            }
        }
        throw new IllegalArgumentException("Deduplication not supported for entity type: " + type);
    }

    public static ColumnFamily decodeCF(byte[] b) {
        String[] s = new String(b).split(CF_SEPARATOR);
        return new DedupUtils().getCF(RelTypeProtos.RelType.valueOf((String)s[0]), RelTypeProtos.SubRelType.valueOf((String)s[1]));
    }

    private ColumnFamily getCF(RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType) {
        return new ColumnFamily(relType, subRelType);
    }

    public static OafProtos.OafRel.Builder getDedup(DedupConfig dedupConf, String from, String to, DedupProtos.Dedup.RelName relClass) {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)dedupConf.getEntityType());
        RelTypeProtos.RelType relType = DedupUtils.getRelType(type);
        OafProtos.OafRel.Builder oafRel = OafProtos.OafRel.newBuilder().setRelType(relType).setSubRelType(RelTypeProtos.SubRelType.dedup).setRelClass(relClass.toString()).setChild(false).setSource(new String(from)).setTarget(new String(to));
        switch (type) {
            case organization: {
                oafRel.setOrganizationOrganization(OrganizationOrganizationProtos.OrganizationOrganization.newBuilder().setDedup(DedupUtils.dedup(relClass, "dnet:organization_organization_relations")));
                break;
            }
            case person: {
                oafRel.setPersonPerson(PersonPersonProtos.PersonPerson.newBuilder().setDedup(DedupUtils.dedup(relClass, "dnet:person_person_relations")));
                break;
            }
            case result: {
                oafRel.setResultResult(ResultResultProtos.ResultResult.newBuilder().setDedup(DedupUtils.dedup(relClass, "dnet:result_result_relations")));
                break;
            }
            default: {
                throw new IllegalArgumentException("Deduplication not supported for entity type: " + dedupConf.getEntityType());
            }
        }
        return oafRel;
    }

    private static DedupProtos.Dedup.Builder dedup(DedupProtos.Dedup.RelName relClass, String scheme) {
        return DedupProtos.Dedup.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(FieldTypeProtos.Qualifier.newBuilder().setClassid(relClass.toString()).setClassname(relClass.toString()).setSchemeid(scheme).setSchemename(scheme)));
    }

    class ColumnFamily {
        private final RelTypeProtos.RelType relType;
        private final RelTypeProtos.SubRelType subRelType;

        public ColumnFamily(RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType) {
            this.relType = relType;
            this.subRelType = subRelType;
        }

        public String toString() {
            return this.getRelType() + DedupUtils.CF_SEPARATOR + this.getSubRelType();
        }

        public RelTypeProtos.RelType getRelType() {
            return this.relType;
        }

        public RelTypeProtos.SubRelType getSubRelType() {
            return this.subRelType;
        }
    }
}

