/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public class HBaseTableUtils {
    public static final String lowerKey = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    public static final String upperKey = "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz";
    private static Function<TypeProtos.Type, String> typeName = new Function<TypeProtos.Type, String>(){

        public String apply(TypeProtos.Type type) {
            return type.toString();
        }
    };
    private static Function<RelTypeProtos.RelType, String> relTypeName = new Function<RelTypeProtos.RelType, String>(){

        public String apply(RelTypeProtos.RelType type) {
            return type.toString();
        }
    };
    private static Function<VolatileColumnFamily, String> extraColumnFamilyName = new Function<VolatileColumnFamily, String>(){

        public String apply(VolatileColumnFamily type) {
            return type.toString();
        }
    };

    public static Set<String> listColumns() {
        return Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])TypeProtos.Type.values()), typeName), (Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])RelTypeProtos.RelType.values()), relTypeName), (Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])VolatileColumnFamily.values()), extraColumnFamilyName)));
    }

    public static byte[][] getHexSplits(List<String> splitKeys) {
        byte[][] splits = new byte[splitKeys.size() - 1][];
        for (int i = 0; i < splitKeys.size() - 1; ++i) {
            byte[] b = splitKeys.get(i).getBytes();
            splits[i] = b;
        }
        return splits;
    }

    public static byte[][] getHexSplits(int numRegions) {
        return HBaseTableUtils.getHexSplits(lowerKey, upperKey, numRegions);
    }

    public static byte[][] getHexSplits(String startKey, String endKey, int numRegions) {
        byte[][] splits = new byte[numRegions - 1][];
        BigInteger lowestKey = new BigInteger(startKey, 16);
        BigInteger highestKey = new BigInteger(endKey, 16);
        BigInteger range = highestKey.subtract(lowestKey);
        BigInteger regionIncrement = range.divide(BigInteger.valueOf(numRegions));
        lowestKey = lowestKey.add(regionIncrement);
        for (int i = 0; i < numRegions - 1; ++i) {
            BigInteger key = lowestKey.add(regionIncrement.multiply(BigInteger.valueOf(i)));
            byte[] b = String.format("%016x", key).getBytes();
            splits[i] = b;
        }
        return splits;
    }

    public static enum VolatileColumnFamily {
        dedup,
        dedupPerson;


        public static boolean isVolatile(String columnName) {
            try {
                return VolatileColumnFamily.valueOf(columnName) != null;
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

