package eu.dnetlib.data.mapreduce.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper.Context;

import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;

import eu.dnetlib.data.proto.OafProtos.Oaf;

public class UpdateMerger {

	private static final String UPDATE_MERGER = "UPDATE_MERGE";
	private static final String N_MERGES = "N_MERGES";

	@SuppressWarnings("rawtypes")
	public static Oaf mergeBodyUpdates(final Context context, final Map<byte[], byte[]> map) throws InvalidProtocolBufferException {
		byte[] value = map.get(DedupUtils.BODY_B);
		if (value == null) return null;

		Oaf.Builder builder = Oaf.newBuilder(Oaf.parseFrom(value));
		final List<String> keys = Lists.newArrayList();

		// we fetch all the body updates
		for (byte[] o : map.keySet()) {
			final String sKey = Bytes.toString(o);
			if (sKey.startsWith("update_")) {
				keys.add(sKey);
			}
		}
		if (!keys.isEmpty()) {
			// we merge all the sorted updates with the body
			Collections.sort(keys);
			for (String k : keys) {
				Oaf update = Oaf.parseFrom(map.get(Bytes.toBytes(k)));
				// System.out.println("\n\nBODY: \n" + body.build().toString());
				// System.out.println("UPDATE: \n" + update.toString());
				builder.mergeFrom(update);
				// System.out.println("UDPATED BODY: \n" + body.build().toString() + "\n\n");
			}

			builder = OafEntityMerger.merge(builder);

			context.getCounter(UPDATE_MERGER, N_MERGES).increment(keys.size());
		}
		return builder.build();
	}

}
