/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.oai;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import eu.dnetlib.data.mapreduce.hbase.oai.config.OAIConfiguration;
import eu.dnetlib.data.mapreduce.hbase.oai.config.OAIConfigurationStringReader;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.MongoSetCollection;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.PublisherField;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.RecordFieldsExtractor;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.SetInfo;
import eu.dnetlib.miscutils.functional.xml.IndentXmlString;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.solr.common.util.DateUtil;

public class OaiFeedMapper
extends Mapper<Text, Text, NullWritable, NullWritable> {
    private DBCollection collection;
    private DBCollection discardedCollection;
    private final boolean upsert = true;
    private final boolean multi = false;
    private OAIConfigurationStringReader oaiConfigurationReader;
    private OAIConfiguration oaiConfiguration;
    private Date feedDate;
    private MongoSetCollection mongoSetCollection;
    private RecordFieldsExtractor extractor;
    private String format;
    private String interpretation;
    private String layout;
    private Map<String, PublisherField> fieldsToIndex = Maps.newHashMap();

    protected void setup(Mapper.Context context) throws UnknownHostException {
        String host = context.getConfiguration().get("services.publisher.oai.host");
        String port = context.getConfiguration().get("services.publisher.oai.port");
        String db = context.getConfiguration().get("services.publisher.oai.db");
        String collectionName = context.getConfiguration().get("services.publisher.oai.collection");
        System.out.println("Mongodb client params");
        System.out.println("host: " + host);
        System.out.println("port: " + port);
        System.out.println("db: " + db);
        System.out.println("collection: " + collectionName);
        String[] formatLayoutInterp = collectionName.split("-");
        this.format = formatLayoutInterp[0];
        this.layout = formatLayoutInterp[1];
        this.interpretation = formatLayoutInterp[2];
        String oaiConfigurationProfile = context.getConfiguration().get("oaiConfiguration");
        System.out.println("oaiConfiguration:\n" + IndentXmlString.apply((String)oaiConfigurationProfile));
        this.oaiConfigurationReader = new OAIConfigurationStringReader(oaiConfigurationProfile);
        this.oaiConfiguration = this.oaiConfigurationReader.getOaiConfiguration();
        System.out.println("parsed configuration:" + this.oaiConfiguration.toString());
        Mongo mongo = new Mongo(host, Integer.parseInt(port));
        DB mongoDB = mongo.getDB(db);
        this.collection = mongoDB.getCollection(collectionName);
        this.discardedCollection = mongoDB.getCollection("discarded-" + collectionName);
        this.mongoSetCollection = new MongoSetCollection(mongoDB);
        Collection<PublisherField> indexFields = this.oaiConfiguration.getFieldsFor(this.format, this.layout, this.interpretation);
        this.extractor = new RecordFieldsExtractor(Lists.newArrayList(indexFields));
        for (PublisherField field : indexFields) {
            this.fieldsToIndex.put(field.getFieldName(), field);
        }
        String feedDateString = context.getConfiguration().get("oai.feed.date");
        try {
            this.feedDate = DateUtil.parseDate((String)feedDateString);
        }
        catch (ParseException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String recordKey = key.toString();
        String recordBody = value.toString();
        if (StringUtils.isBlank((String)recordBody)) {
            this.discard(context, recordKey, recordBody, "blank body");
        } else {
            Multimap<String, String> recordFields = this.extractor.extractFields(recordBody);
            String id = "";
            String oaiID = "";
            if (recordFields == null) {
                context.getCounter("oai", "invalid").increment(1L);
            } else if (recordFields.containsKey((Object)"objIdentifier")) {
                id = (String)recordFields.get((Object)"objIdentifier").iterator().next();
                oaiID = this.getOAIIdentifier(id);
                this.handleRecord(this.getRecordStatus(oaiID, recordBody), context, oaiID, recordBody, recordFields);
            } else {
                this.discard(context, recordKey, recordBody, "missing objIdentifier");
            }
        }
    }

    private void handleRecord(RecordStatus status, Mapper.Context context, String oaiID, String record, Multimap<String, String> recordProperties) {
        BasicDBObject oldObj = new BasicDBObject("objIdentifier", (Object)oaiID);
        DBObject obj = null;
        String counterReason = "";
        switch (status) {
            case NEW: {
                obj = this.createBasicObject(oaiID, record, recordProperties, context);
                obj.put("lastCollectionDate", (Object)this.feedDate);
                obj.put("datestamp", (Object)this.feedDate);
                obj.put("updated", (Object)false);
                counterReason = "new record";
                break;
            }
            case UPDATED: {
                obj = this.createBasicObject(oaiID, record, recordProperties, context);
                obj.put("lastCollectionDate", (Object)this.feedDate);
                obj.put("datestamp", (Object)this.feedDate);
                obj.put("updated", (Object)true);
                counterReason = "updated record";
                break;
            }
            case UNCHANGED: {
                obj = new BasicDBObject("$set", (Object)new BasicDBObject("lastCollectionDate", (Object)this.feedDate));
                counterReason = "unchanged record";
            }
        }
        this.collection.insert(new DBObject[]{obj});
        context.getCounter("oai", counterReason).increment(1L);
        context.getCounter("oai", "total").increment(1L);
    }

    private void upsertSets(Iterable<String> setNames) {
        if (setNames != null) {
            for (String setName : setNames) {
                if (!StringUtils.isNotBlank((String)setName)) continue;
                SetInfo set = new SetInfo();
                String setSpec = this.mongoSetCollection.normalizeSetSpec(setName);
                set.setSetSpec(setSpec);
                set.setSetName(setName);
                set.setSetDescription("This set contains metadata records whose provenance is " + setName);
                set.setEnabled(true);
                String query = "set = \"" + setSpec + "\"";
                set.setQuery(query);
                this.mongoSetCollection.upsertSet(set, false);
            }
        }
    }

    private void discard(Mapper.Context context, String recordKey, String recordBody, String reason) {
        context.getCounter("oai", reason).increment(1L);
        this.discardedCollection.insert(new DBObject[]{new BasicDBObject("id", (Object)recordKey).append("body", (Object)recordBody)});
    }

    private String getOAIIdentifier(String id) {
        return this.oaiConfiguration.getIdScheme() + ":" + this.oaiConfiguration.getIdNamespace() + ":" + id;
    }

    private RecordStatus getRecordStatus(String oaiId, String recordBody) {
        if (this.isNewRecord(oaiId)) {
            return RecordStatus.NEW;
        }
        if (this.isChanged(oaiId, recordBody)) {
            return RecordStatus.UPDATED;
        }
        return RecordStatus.UNCHANGED;
    }

    private boolean isNewRecord(String oaiIdentifier) {
        return true;
    }

    private boolean isChanged(String oaiID, String recordBody) {
        return true;
    }

    protected DBObject createBasicObject(String oaiID, String record, Multimap<String, String> recordProperties, Mapper.Context context) {
        BasicDBObject obj = new BasicDBObject();
        for (String key : recordProperties.keySet()) {
            if (key.equals("objIdentifier")) {
                obj.put(key, (Object)oaiID);
                continue;
            }
            Collection values = recordProperties.get((Object)key);
            if (key.equals("set")) {
                Iterable setSpecs = Iterables.transform((Iterable)values, (Function)new Function<String, String>(){

                    public String apply(String s) {
                        return OaiFeedMapper.this.mongoSetCollection.normalizeSetSpec(s);
                    }
                });
                obj.put(key, (Object)setSpecs);
                continue;
            }
            PublisherField keyField = this.fieldsToIndex.get(key);
            if (keyField == null) {
                context.getCounter("oai", key + " found for record but not in configuration. Assuming it is repeatable.").increment(1L);
            }
            if (keyField != null && !keyField.isRepeatable()) {
                if (values == null || values.isEmpty()) continue;
                obj.put(key, values.iterator().next());
                continue;
            }
            obj.put(key, (Object)values);
        }
        obj.put("body", (Object)record);
        obj.put("deleted", (Object)false);
        return obj;
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    public void setCollection(DBCollection collection) {
        this.collection = collection;
    }

    public DBCollection getDiscardedCollection() {
        return this.discardedCollection;
    }

    public void setDiscardedCollection(DBCollection discardedCollection) {
        this.discardedCollection = discardedCollection;
    }

    public OAIConfigurationStringReader getOaiConfigurationReader() {
        return this.oaiConfigurationReader;
    }

    public void setOaiConfigurationReader(OAIConfigurationStringReader oaiConfigurationReader) {
        this.oaiConfigurationReader = oaiConfigurationReader;
    }

    public OAIConfiguration getOaiConfiguration() {
        return this.oaiConfiguration;
    }

    public void setOaiConfiguration(OAIConfiguration oaiConfiguration) {
        this.oaiConfiguration = oaiConfiguration;
    }

    public Date getFeedDate() {
        return this.feedDate;
    }

    public void setFeedDate(Date feedDate) {
        this.feedDate = feedDate;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    static enum RecordStatus {
        NEW,
        UPDATED,
        UNCHANGED;

    }
}

