/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupMapper;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupReducer;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class DedupJob
extends AbstractHBaseMapReduceJob {
    @Override
    public Job setJobDetails(Job job, Properties p) {
        this.initJob(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.setNumReduceTasks(1000);
        job.getConfiguration().setBoolean("mapred.compress.map.output", true);
        job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
        job.getConfiguration().setBoolean("mapreduce.reduce.speculative", false);
        return job;
    }

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(500);
        scan.setCacheBlocks(false);
        DedupConfig dedupConfig = DedupConfigLoader.load((String)p.getProperty("dedup.wf.conf"));
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)dedupConfig.getEntityType());
        scan.setFilter((Filter)new PrefixFilter(Bytes.toBytes((int)type.getNumber())));
        scan.addFamily(dedupConfig.getEntityNameBytes());
        return scan;
    }

    private void initJob(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, DedupMapper.class, Text.class, ImmutableBytesWritable.class, (Job)job);
            TableMapReduceUtil.initTableReducerJob((String)sourceTable, DedupReducer.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

