/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafUtils;
import eu.dnetlib.data.mapreduce.util.TrustOrdering;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.SpecialTrustProtos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class OafEntityMerger {
    private final Predicate<FieldTypeProtos.StringField> skipEmptyStringField = new Predicate<FieldTypeProtos.StringField>(){

        public boolean apply(FieldTypeProtos.StringField s) {
            return s != null && s.getValue() != null && !s.getValue().isEmpty();
        }
    };
    private final Predicate<String> skipEmptyString = new Predicate<String>(){

        public boolean apply(String s) {
            return s != null && !s.isEmpty();
        }
    };

    public static OafProtos.Oaf.Builder merge(String id, Iterable<OafProtos.Oaf> entities) {
        return new OafEntityMerger().mergeEntities(id, entities);
    }

    public static OafProtos.Oaf.Builder merge(OafProtos.Oaf.Builder builder) {
        return new OafEntityMerger().doMergeEntities(builder);
    }

    public OafProtos.Oaf.Builder mergeEntities(String id, Iterable<OafProtos.Oaf> entities) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder();
        String trust = "0.0";
        for (OafProtos.Oaf oaf : TrustOrdering.sort(entities)) {
            if (!oaf.getKind().equals((Object)KindProtos.Kind.entity)) {
                throw new IllegalArgumentException("expected OafEntity!");
            }
            String currentTrust = oaf.getDataInfo().getTrust();
            if (!currentTrust.equals(SpecialTrustProtos.SpecialTrust.NEUTRAL.toString())) {
                trust = currentTrust;
            }
            builder.mergeFrom(oaf);
        }
        builder = this.doMergeEntities(builder);
        builder.getEntityBuilder().setId(id);
        builder.getDataInfoBuilder().setInferred(true).setDeletedbyinference(false).setTrust(trust);
        return builder;
    }

    public OafProtos.Oaf.Builder doMergeEntities(OafProtos.Oaf.Builder builder) {
        switch (builder.getEntity().getType()) {
            case datasource: {
                break;
            }
            case organization: {
                break;
            }
            case person: {
                PersonProtos.Person.Metadata.Builder person = builder.getEntityBuilder().getPersonBuilder().getMetadataBuilder();
                for (String field : Lists.newArrayList((Object[])new String[]{"secondnames"})) {
                    this.setSingleString((Message.Builder)person, field);
                }
                break;
            }
            case project: {
                break;
            }
            case result: {
                ResultProtos.Result.Metadata.Builder result = builder.getEntityBuilder().getResultBuilder().getMetadataBuilder();
                this.setTitle(result);
                for (String field : OafUtils.getFieldNames(ResultProtos.Result.Metadata.getDescriptor(), 1, 3)) {
                    this.setStructuredProperty((Message.Builder)result, field);
                }
                for (String field : OafUtils.getFieldNames(ResultProtos.Result.Metadata.getDescriptor(), 25)) {
                    this.setLongestStringField((Message.Builder)result, field);
                }
                for (String field : OafUtils.getFieldNames(ResultProtos.Result.Metadata.getDescriptor(), 27)) {
                    this.setUniqueStringField((Message.Builder)result, field);
                }
                for (String field : OafUtils.getFieldNames(OafProtos.OafEntity.getDescriptor(), 9)) {
                    this.setKeyValues((Message.Builder)builder.getEntityBuilder(), field);
                }
                for (String field : OafUtils.getFieldNames(OafProtos.OafEntity.getDescriptor(), 10)) {
                    this.setStructuredProperty((Message.Builder)builder.getEntityBuilder(), field);
                }
                for (String field : OafUtils.getFieldNames(OafProtos.OafEntity.getDescriptor(), 8)) {
                    this.setUniqueString((Message.Builder)builder.getEntityBuilder(), field);
                }
                break;
            }
        }
        return builder;
    }

    private void setStructuredProperty(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List sps = (List)builder.getField(fd);
        if (sps != null && !sps.isEmpty()) {
            for (FieldTypeProtos.StructuredProperty sp : sps) {
                map.put(sp.getValue(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setKeyValues(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List kvs = (List)builder.getField(fd);
        if (kvs != null && !kvs.isEmpty()) {
            for (FieldTypeProtos.KeyValue sp : kvs) {
                map.put(sp.getKey(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setSingleString(Message.Builder builder, String fieldName) {
        FieldTypeProtos.StringField s;
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        if (field != null && !field.isEmpty() && (s = (FieldTypeProtos.StringField)Iterables.getLast((Iterable)Iterables.filter((Iterable)field, this.skipEmptyStringField), (Object)"")) != null && s.getValue() != null && !s.getValue().isEmpty()) {
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Object[])new FieldTypeProtos.StringField[]{s}));
        }
    }

    private void setLongestStringField(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        if (field != null && !field.isEmpty()) {
            FieldTypeProtos.StringField.Builder max = FieldTypeProtos.StringField.newBuilder().setValue("");
            int maxLength = 0;
            for (FieldTypeProtos.StringField sf : field) {
                if (sf.getValue().length() <= maxLength) continue;
                maxLength = sf.getValue().length();
                max.clear();
                max.mergeFrom(sf);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Object[])new FieldTypeProtos.StringField[]{max.build()}));
        }
    }

    private void setUniqueStringField(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        HashMap map = Maps.newHashMap();
        if (field != null && !field.isEmpty()) {
            for (FieldTypeProtos.StringField s : Iterables.filter((Iterable)field, this.skipEmptyStringField)) {
                map.put(s.getValue(), s);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
        }
    }

    private void setUniqueString(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        HashSet set = Sets.newHashSet();
        if (field != null && !field.isEmpty()) {
            for (String s : Iterables.filter((Iterable)field, this.skipEmptyString)) {
                set.add(s);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Iterable)set));
        }
    }

    private void setTitle(ResultProtos.Result.Metadata.Builder metadata) {
        Iterable filtered = Iterables.filter((Iterable)metadata.getTitleList(), OafUtils.mainTitleFilter());
        if (!Iterables.isEmpty((Iterable)filtered)) {
            metadata.clearTitle().addTitle((FieldTypeProtos.StructuredProperty)Iterables.getLast((Iterable)filtered));
        }
    }
}

