package eu.dnetlib.data.mapreduce.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;

public class DnetFuzzyFilter extends FilterBase {
	protected byte[] mask = null;
	protected boolean passedMask = false;

	public final static byte jolly = '?';

	public DnetFuzzyFilter(final byte[] mask) {
		this.mask = mask;
	}

	public DnetFuzzyFilter() {
		super();
	}

	public byte[] getMask() {
		return mask;
	}

	@Override
	public boolean filterRowKey(byte[] buffer, int offset, int length) {
		if (buffer == null || this.mask == null) {
			return true;
		}
		if (length != mask.length) {
			return true;
		}

		//Returns true if buffer doesn't match the mask 
		for (int i = 0; i < length; i++) {
			if (mask[i] != jolly && buffer[i] != mask[i]) {
				passedMask = true;
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean filterAllRemaining() {
		return passedMask;
	}

	@Override
	public void write(DataOutput out) throws IOException {
		Bytes.writeByteArray(out, this.mask);
	}

	@Override
	public void readFields(DataInput in) throws IOException {
		this.mask = Bytes.readByteArray(in);
	}
}
